/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.json.moduleconfig;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import lombok.Generated;
import org.jboss.pnc.common.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakClientConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeycloakClientConfig.class);
    private final String realm;
    private final String realmPublicKey;
    private final String authServerUrl;
    private final Boolean sslRequired;
    private final String resource;
    private final Map<String, String> credentials;

    @JsonCreator
    public KeycloakClientConfig(@JsonProperty(value="realm") String realm, @JsonProperty(value="realm-public-key") String realmPublicKey, @JsonProperty(value="auth-server-url") String authServerUrl, @JsonProperty(value="ssl-required") Boolean sslRequired, @JsonProperty(value="resource") String resource, @JsonProperty(value="credentials") @DefaultValue(value="{}") Map<String, String> credentials) {
        this.realm = realm;
        this.realmPublicKey = realmPublicKey;
        this.authServerUrl = authServerUrl;
        this.sslRequired = sslRequired;
        this.resource = resource;
        this.credentials = credentials;
    }

    @JsonIgnore
    public String getSecret() {
        String secretPath = this.credentials.get("secretFileLocation");
        try {
            return IoUtils.readFileAsString((File)new File(secretPath)).trim();
        }
        catch (IOException e) {
            log.error("Error while getting secret token", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Generated
    public String getRealm() {
        return this.realm;
    }

    @Generated
    public String getRealmPublicKey() {
        return this.realmPublicKey;
    }

    @Generated
    public String getAuthServerUrl() {
        return this.authServerUrl;
    }

    @Generated
    public Boolean getSslRequired() {
        return this.sslRequired;
    }

    @Generated
    public String getResource() {
        return this.resource;
    }

    @Generated
    public Map<String, String> getCredentials() {
        return this.credentials;
    }
}

