/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.json.moduleprovider;

import java.util.ArrayList;
import lombok.Generated;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.pnc.common.Configuration;
import org.jboss.pnc.common.json.AbstractModuleConfig;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.common.json.moduleconfig.SchedulerConfig;
import org.jboss.pnc.common.json.moduleconfig.microprofile.SchedulerMicroprofileConfig;
import org.jboss.pnc.common.json.moduleprovider.PncConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroprofileConfigRegistrar
implements ConfigSourceProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicroprofileConfigRegistrar.class);
    private final Configuration configuration;

    public MicroprofileConfigRegistrar() {
        try {
            this.configuration = new Configuration();
        }
        catch (ConfigurationParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader classLoader) {
        ArrayList<ConfigSource> microprofileConfig = new ArrayList<ConfigSource>();
        try {
            microprofileConfig.add(new SchedulerMicroprofileConfig(this.getModuleConfig(SchedulerConfig.class)));
        }
        catch (ConfigurationParseException ignored) {
            log.error("SchedulerConfig haven't been found and microprofile wrapper may be missing.");
        }
        return microprofileConfig;
    }

    private <T extends AbstractModuleConfig> T getModuleConfig(Class<T> configClass) throws ConfigurationParseException {
        return (T)this.configuration.getModuleConfig(new PncConfigProvider<T>(configClass));
    }
}

