/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.notification;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.Session;
import org.jboss.pnc.rest.jackson.JacksonProvider;
import org.jboss.pnc.spi.notifications.AttachedClient;
import org.jboss.pnc.spi.notifications.MessageCallback;
import org.jboss.pnc.spi.notifications.Notifier;

public class SessionBasedAttachedClient
implements AttachedClient {
    private final Session session;
    private Notifier notifier;
    private final JacksonProvider mapperProvider = new JacksonProvider();
    private List<Subscription> subscriptions = new ArrayList<Subscription>();

    public SessionBasedAttachedClient(Session session, Notifier notifier) {
        this.session = session;
        this.notifier = notifier;
    }

    public boolean isEnabled() {
        return this.session.isOpen();
    }

    public String getSessionId() {
        return this.session.getId();
    }

    public void sendMessage(Object messageBody, MessageCallback callback) {
        String message;
        try {
            message = this.mapperProvider.getMapper().writeValueAsString(messageBody);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not convert object to JSON", e);
        }
        this.session.getAsyncRemote().sendText(message, sendResult -> {
            if (!sendResult.isOK()) {
                callback.failed((AttachedClient)this, sendResult.getException());
            } else {
                callback.successful((AttachedClient)this);
            }
        });
    }

    public void subscribe(String topic, String messagesId) {
        this.subscriptions.add(new Subscription(topic, messagesId));
        if (topic.equals(Notifier.Topic.COMPONENT_BUILD.getId())) {
            this.notifier.onBpmProcessClientSubscribe((AttachedClient)this, messagesId);
        }
    }

    public void unsubscribe(String topic, String messagesId) {
        this.subscriptions.remove(new Subscription(topic, messagesId));
    }

    public boolean isSubscribed(String topic, String qualifier) {
        for (Subscription subscription : this.subscriptions) {
            if (!topic.equals(subscription.getTopic()) || !subscription.getQualifier().equals("") && !subscription.getQualifier().equals(qualifier)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionBasedAttachedClient that = (SessionBasedAttachedClient)o;
        return !(this.session != null ? !this.session.equals(that.session) : that.session != null);
    }

    public int hashCode() {
        int result = this.session != null ? this.session.hashCode() : 0;
        return result;
    }

    private class Subscription {
        String topic;
        String qualifier;

        public Subscription(String topic, String qualifier) {
            this.topic = topic;
            this.qualifier = qualifier;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Subscription)) {
                return false;
            }
            Subscription other = (Subscription)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
                return false;
            }
            String this$qualifier = this.getQualifier();
            String other$qualifier = other.getQualifier();
            return !(this$qualifier == null ? other$qualifier != null : !this$qualifier.equals(other$qualifier));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Subscription;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            String $qualifier = this.getQualifier();
            result = result * 59 + ($qualifier == null ? 43 : $qualifier.hashCode());
            return result;
        }

        public String getTopic() {
            return this.topic;
        }

        public String getQualifier() {
            return this.qualifier;
        }
    }
}

