/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.notification;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.jboss.pnc.common.concurrent.MDCExecutors;
import org.jboss.pnc.dto.BuildPushResult;
import org.jboss.pnc.dto.ProductMilestoneCloseResult;
import org.jboss.pnc.dto.notification.BuildChangedNotification;
import org.jboss.pnc.dto.notification.BuildPushResultNotification;
import org.jboss.pnc.dto.notification.GroupBuildChangedNotification;
import org.jboss.pnc.dto.notification.OperationNotification;
import org.jboss.pnc.dto.notification.ProductMilestoneCloseResultNotification;
import org.jboss.pnc.model.DeliverableAnalyzerOperation;
import org.jboss.pnc.spi.events.BuildSetStatusChangedEvent;
import org.jboss.pnc.spi.events.BuildStatusChangedEvent;
import org.jboss.pnc.spi.events.OperationChangedEvent;
import org.jboss.pnc.spi.notifications.AttachedClient;
import org.jboss.pnc.spi.notifications.MessageCallback;
import org.jboss.pnc.spi.notifications.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultNotifier
implements Notifier {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Set<AttachedClient> attachedClients = new CopyOnWriteArraySet<AttachedClient>();
    private final ScheduledExecutorService scheduler = MDCExecutors.newScheduledThreadPool((int)1);
    private final MessageCallback messageCallback = new MessageCallback(){

        public void successful(AttachedClient attachedClient) {
        }

        public void failed(AttachedClient attachedClient, Throwable throwable) {
            logger.error("Notification client threw an error, removing it", throwable);
            DefaultNotifier.this.detachClient(attachedClient);
        }
    };

    @PostConstruct
    public void init() {
        this.scheduler.scheduleAtFixedRate(this::cleanUp, 1L, 1L, TimeUnit.HOURS);
    }

    public void attachClient(AttachedClient attachedClient) {
        this.attachedClients.add(attachedClient);
    }

    public void detachClient(AttachedClient attachedClient) {
        this.attachedClients.remove(attachedClient);
    }

    public int getAttachedClientsCount() {
        return this.attachedClients.size();
    }

    public MessageCallback getCallback() {
        return this.messageCallback;
    }

    public void sendMessage(Object message) {
        for (AttachedClient client : this.attachedClients) {
            if (!client.isEnabled()) continue;
            try {
                client.sendMessage(message, this.messageCallback);
            }
            catch (Exception e) {
                logger.error("Unable to send message, detaching client.", (Throwable)e);
                this.detachClient(client);
            }
        }
    }

    public void cleanUp() {
        for (AttachedClient client : this.attachedClients) {
            if (client.isEnabled()) continue;
            this.detachClient(client);
        }
    }

    public void collectBuildPushResultEvent(@Observes BuildPushResult buildPushResult) {
        logger.trace("Observed new BuildPushResult event {}.", (Object)buildPushResult);
        this.sendMessage(new BuildPushResultNotification(buildPushResult));
        logger.trace("BuildPushResult event processed {}.", (Object)buildPushResult);
    }

    public void collectBuildStatusChangedEvent(@Observes BuildStatusChangedEvent buildStatusChangedEvent) {
        logger.trace("Observed new status changed event {}.", (Object)buildStatusChangedEvent);
        this.sendMessage(new BuildChangedNotification(buildStatusChangedEvent.getOldStatus(), buildStatusChangedEvent.getBuild()));
        logger.trace("Status changed event processed {}.", (Object)buildStatusChangedEvent);
    }

    public void collectBuildSetStatusChangedEvent(@Observes BuildSetStatusChangedEvent buildSetStatusChangedEvent) {
        logger.trace("Observed new set status changed event {}.", (Object)buildSetStatusChangedEvent);
        this.sendMessage(new GroupBuildChangedNotification(buildSetStatusChangedEvent.getGroupBuild()));
        logger.trace("Set status changed event processed {}.", (Object)buildSetStatusChangedEvent);
    }

    public void collectProductMilestoneCloseResultEvent(@Observes ProductMilestoneCloseResult milestoneCloseResult) {
        logger.trace("Observed new MilestoneCloseResult event {}.", (Object)milestoneCloseResult);
        this.sendMessage(new ProductMilestoneCloseResultNotification(milestoneCloseResult));
        logger.trace("ProductMilestoneCloseResult event processed {}.", (Object)milestoneCloseResult);
    }

    public void collectOperationChangedEvent(@Observes OperationChangedEvent operationChangedEvent) {
        logger.trace("Observed new OperationChangedEvent event {}.", (Object)operationChangedEvent);
        String notificationType = operationChangedEvent.getOperationClass() == DeliverableAnalyzerOperation.class ? "DELIVERABLES_ANALYSIS" : "UNKNOWN-OPERATION";
        this.sendMessage(new OperationNotification(notificationType, operationChangedEvent.getId().toString(), operationChangedEvent.getStatus(), operationChangedEvent.getPreviousStatus(), operationChangedEvent.getResult()));
        logger.trace("OperationChangedEvent event processed {}.", (Object)operationChangedEvent);
    }
}

