/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.notification;

import com.fasterxml.jackson.core.JsonProcessingException;
import javax.websocket.Session;
import org.jboss.pnc.rest.jackson.JacksonProvider;
import org.jboss.pnc.spi.notifications.AttachedClient;
import org.jboss.pnc.spi.notifications.MessageCallback;

public class SessionBasedAttachedClient
implements AttachedClient {
    private final Session session;
    private final JacksonProvider mapperProvider = new JacksonProvider();

    public SessionBasedAttachedClient(Session session) {
        this.session = session;
    }

    public boolean isEnabled() {
        return this.session.isOpen();
    }

    public String getSessionId() {
        return this.session.getId();
    }

    public void sendMessage(Object messageBody, MessageCallback callback) {
        String message;
        try {
            message = this.mapperProvider.getMapper().writeValueAsString(messageBody);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not convert object to JSON", e);
        }
        this.session.getAsyncRemote().sendText(message, sendResult -> {
            if (!sendResult.isOK()) {
                callback.failed((AttachedClient)this, sendResult.getException());
            } else {
                callback.successful((AttachedClient)this);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionBasedAttachedClient that = (SessionBasedAttachedClient)o;
        return !(this.session != null ? !this.session.equals(that.session) : that.session != null);
    }

    public int hashCode() {
        int result = this.session != null ? this.session.hashCode() : 0;
        return result;
    }
}

