/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.notification.dist;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import org.jboss.pnc.common.json.moduleconfig.SystemConfig;
import org.jboss.pnc.notification.dist.AbstractDistributedEventHandler;
import org.jboss.pnc.notification.dist.DistributedEventHandler;
import org.jboss.pnc.notification.dist.DistributedEventHandlerFactory;
import org.jboss.pnc.notification.dist.InfinispanDistributedEventHandler;
import org.jboss.pnc.notification.dist.KafkaDistributedEventHandler;
import org.jboss.pnc.notification.dist.LocalEventHandler;
import org.jboss.pnc.spi.notifications.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultDistributedEventHandlerFactory
implements DistributedEventHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDistributedEventHandlerFactory.class);

    @Override
    @Produces
    @ApplicationScoped
    public DistributedEventHandler createDistributedEventHandler(SystemConfig config, Notifier notifier) {
        AbstractDistributedEventHandler handler = "kafka".equalsIgnoreCase(config.getDistributedEventType()) ? new KafkaDistributedEventHandler(config) : ("infinispan".equalsIgnoreCase(config.getDistributedEventType()) ? new InfinispanDistributedEventHandler(config) : new LocalEventHandler());
        handler.notifier = notifier;
        handler.start();
        return handler;
    }

    public void closeDistributedEventHandler(@Disposes DistributedEventHandler handler) {
        try {
            handler.close();
        }
        catch (Exception e) {
            logger.warn("Error closing distributed event handler", (Throwable)e);
        }
    }
}

