/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.notification;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.pnc.dto.BuildPushResult;
import org.jboss.pnc.dto.DeliverableAnalyzerOperation;
import org.jboss.pnc.dto.ProductMilestoneCloseResult;
import org.jboss.pnc.dto.notification.BuildChangedNotification;
import org.jboss.pnc.dto.notification.BuildPushResultNotification;
import org.jboss.pnc.dto.notification.GroupBuildChangedNotification;
import org.jboss.pnc.dto.notification.OperationNotification;
import org.jboss.pnc.dto.notification.ProductMilestoneCloseResultNotification;
import org.jboss.pnc.mapper.api.DeliverableAnalyzerOperationMapper;
import org.jboss.pnc.notification.dist.DistributedEventHandler;
import org.jboss.pnc.spi.datastore.repositories.DeliverableAnalyzerOperationRepository;
import org.jboss.pnc.spi.events.BuildSetStatusChangedEvent;
import org.jboss.pnc.spi.events.BuildStatusChangedEvent;
import org.jboss.pnc.spi.events.OperationChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultEventObserver {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    DistributedEventHandler handler;
    @Inject
    DeliverableAnalyzerOperationRepository deliverableAnalyzerOperationRepository;
    @Inject
    DeliverableAnalyzerOperationMapper deliverableAnalyzerOperationMapper;

    private void sendMessage(Object msg) {
        this.handler.sendEvent(msg);
    }

    public void collectBuildPushResultEvent(@Observes BuildPushResult buildPushResult) {
        logger.trace("Observed new BuildPushResult event {}.", (Object)buildPushResult);
        this.sendMessage(new BuildPushResultNotification(buildPushResult));
        logger.trace("BuildPushResult event processed {}.", (Object)buildPushResult);
    }

    public void collectBuildStatusChangedEvent(@Observes BuildStatusChangedEvent buildStatusChangedEvent) {
        logger.trace("Observed new status changed event {}.", (Object)buildStatusChangedEvent);
        this.sendMessage(new BuildChangedNotification(buildStatusChangedEvent.getOldStatus(), buildStatusChangedEvent.getBuild()));
        logger.trace("Status changed event processed {}.", (Object)buildStatusChangedEvent);
    }

    public void collectBuildSetStatusChangedEvent(@Observes BuildSetStatusChangedEvent buildSetStatusChangedEvent) {
        logger.trace("Observed new set status changed event {}.", (Object)buildSetStatusChangedEvent);
        this.sendMessage(new GroupBuildChangedNotification(buildSetStatusChangedEvent.getGroupBuild(), buildSetStatusChangedEvent.getOldBuildStatus()));
        logger.trace("Set status changed event processed {}.", (Object)buildSetStatusChangedEvent);
    }

    public void collectProductMilestoneCloseResultEvent(@Observes ProductMilestoneCloseResult milestoneCloseResult) {
        logger.trace("Observed new MilestoneCloseResult event {}.", (Object)milestoneCloseResult);
        this.sendMessage(new ProductMilestoneCloseResultNotification(milestoneCloseResult));
        logger.trace("ProductMilestoneCloseResult event processed {}.", (Object)milestoneCloseResult);
    }

    public void collectOperationChangedEvent(@Observes OperationChangedEvent operationChangedEvent) {
        DeliverableAnalyzerOperation operationToSend;
        String notificationType;
        logger.trace("Observed new OperationChangedEvent event {}.", (Object)operationChangedEvent);
        if (operationChangedEvent.getOperationClass() == org.jboss.pnc.model.DeliverableAnalyzerOperation.class) {
            notificationType = "DELIVERABLES_ANALYSIS";
            org.jboss.pnc.model.DeliverableAnalyzerOperation deliverableAnalyzerOperation = (org.jboss.pnc.model.DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.queryById((Serializable)operationChangedEvent.getId());
            deliverableAnalyzerOperation.setProgressStatus(operationChangedEvent.getStatus());
            deliverableAnalyzerOperation.setResult(operationChangedEvent.getResult());
            operationToSend = this.deliverableAnalyzerOperationMapper.toDTO(deliverableAnalyzerOperation);
        } else {
            notificationType = "UNKNOWN-OPERATION";
            operationToSend = null;
        }
        this.sendMessage(new OperationNotification(notificationType, operationChangedEvent.getId().toString(), operationChangedEvent.getStatus(), operationChangedEvent.getPreviousStatus(), operationChangedEvent.getResult(), operationToSend));
        logger.trace("OperationChangedEvent event processed {}.", (Object)operationChangedEvent);
    }
}

