/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.notification;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.notification.MessageType;

@JsonDeserialize(builder=TypedMessageBuilder.class)
@XmlRootElement
public class TypedMessage<T>
implements Serializable {
    private final MessageType messageType;
    private final T data;

    public static <T> TypedMessageBuilder<T> builder() {
        return new TypedMessageBuilder();
    }

    public TypedMessage(MessageType messageType, T data) {
        this.messageType = messageType;
        this.data = data;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public T getData() {
        return this.data;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class TypedMessageBuilder<T> {
        private MessageType messageType;
        private T data;

        private TypedMessageBuilder() {
        }

        public TypedMessageBuilder messageType(MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public TypedMessageBuilder data(T data) {
            this.data = data;
            return this;
        }

        public TypedMessage build() {
            return new TypedMessage<T>(this.messageType, this.data);
        }
    }
}

