/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.notification;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.event.ObservesAsync;
import javax.inject.Inject;
import org.jboss.pnc.api.enums.ProgressStatus;
import org.jboss.pnc.dto.DeliverableAnalyzerOperation;
import org.jboss.pnc.dto.Operation;
import org.jboss.pnc.dto.notification.BuildChangedNotification;
import org.jboss.pnc.dto.notification.GroupBuildChangedNotification;
import org.jboss.pnc.dto.notification.OperationNotification;
import org.jboss.pnc.mapper.api.BuildPushOperationMapper;
import org.jboss.pnc.mapper.api.BuildPushReportMapper;
import org.jboss.pnc.mapper.api.DeliverableAnalyzerOperationMapper;
import org.jboss.pnc.model.BuildPushOperation;
import org.jboss.pnc.notification.dist.DistributedEventHandler;
import org.jboss.pnc.spi.datastore.repositories.BuildPushOperationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildPushReportRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableAnalyzerOperationRepository;
import org.jboss.pnc.spi.events.BuildSetStatusChangedEvent;
import org.jboss.pnc.spi.events.BuildStatusChangedEvent;
import org.jboss.pnc.spi.events.OperationChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultEventObserver {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    DistributedEventHandler handler;
    @Inject
    DeliverableAnalyzerOperationRepository deliverableAnalyzerOperationRepository;
    @Inject
    BuildPushOperationRepository buildPushOperationRepository;
    @Inject
    BuildPushReportRepository buildPushReportRepository;
    @Inject
    BuildPushReportMapper buildPushReportMapper;
    @Inject
    DeliverableAnalyzerOperationMapper deliverableAnalyzerOperationMapper;
    @Inject
    BuildPushOperationMapper buildPushOperationMapper;

    private void sendMessage(Object msg) {
        this.handler.sendEvent(msg);
    }

    public void collectBuildStatusChangedEvent(@Observes BuildStatusChangedEvent buildStatusChangedEvent) {
        logger.trace("Observed new status changed event {}.", (Object)buildStatusChangedEvent);
        this.sendMessage(new BuildChangedNotification(buildStatusChangedEvent.getOldStatus(), buildStatusChangedEvent.getBuild()));
        logger.trace("Status changed event processed {}.", (Object)buildStatusChangedEvent);
    }

    public void collectBuildSetStatusChangedEvent(@Observes BuildSetStatusChangedEvent buildSetStatusChangedEvent) {
        logger.trace("Observed new set status changed event {}.", (Object)buildSetStatusChangedEvent);
        this.sendMessage(new GroupBuildChangedNotification(buildSetStatusChangedEvent.getGroupBuild(), buildSetStatusChangedEvent.getOldBuildStatus()));
        logger.trace("Set status changed event processed {}.", (Object)buildSetStatusChangedEvent);
    }

    public void collectOperationChangedEvent(@ObservesAsync OperationChangedEvent operationChangedEvent) {
        DeliverableAnalyzerOperation operationToSend;
        String notificationType;
        logger.trace("Observed new OperationChangedEvent event {}.", (Object)operationChangedEvent);
        if (operationChangedEvent.getOperationClass() == org.jboss.pnc.model.DeliverableAnalyzerOperation.class) {
            notificationType = "DELIVERABLES_ANALYSIS";
            org.jboss.pnc.model.DeliverableAnalyzerOperation deliverableAnalyzerOperation = (org.jboss.pnc.model.DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.queryById((Serializable)operationChangedEvent.getId());
            deliverableAnalyzerOperation.setProgressStatus(operationChangedEvent.getStatus());
            deliverableAnalyzerOperation.setResult(operationChangedEvent.getResult());
            operationToSend = this.deliverableAnalyzerOperationMapper.toDTO(deliverableAnalyzerOperation);
        } else if (operationChangedEvent.getOperationClass() == BuildPushOperation.class) {
            notificationType = "BUILD_PUSH";
            BuildPushOperation buildPushOperation = (BuildPushOperation)this.buildPushOperationRepository.queryById((Serializable)operationChangedEvent.getId());
            buildPushOperation.setProgressStatus(operationChangedEvent.getStatus());
            buildPushOperation.setResult(operationChangedEvent.getResult());
            operationToSend = this.buildPushOperationMapper.toDTO(buildPushOperation);
            if (buildPushOperation.getProgressStatus() == ProgressStatus.FINISHED) {
                this.sendMessage(this.buildPushReportMapper.fromOperation(buildPushOperation));
            }
        } else {
            notificationType = "UNKNOWN-OPERATION";
            operationToSend = null;
        }
        this.sendMessage(new OperationNotification(notificationType, operationChangedEvent.getId().toString(), operationChangedEvent.getStatus(), operationChangedEvent.getPreviousStatus(), operationChangedEvent.getResult(), (Operation)operationToSend));
        logger.trace("OperationChangedEvent event processed {}.", (Object)operationChangedEvent);
    }
}

