/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.notification.dist;

import io.apicurio.registry.utils.IoUtil;
import java.util.Objects;
import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.jboss.pnc.common.json.moduleconfig.SystemConfig;
import org.jboss.pnc.notification.dist.AbstractDistributedEventHandler;

@Listener(clustered=true, observation=Listener.Observation.POST)
public class InfinispanDistributedEventHandler
extends AbstractDistributedEventHandler {
    private static final String DIST_EVENTS_CACHE = "dist-events-cache";
    private EmbeddedCacheManager manager;
    private Cache<String, String> eventsCache;
    private final SystemConfig config;

    public InfinispanDistributedEventHandler(SystemConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    @Override
    public void sendEvent(Object event) {
        this.eventsCache.put((Object)event.getClass().getName(), (Object)this.toMessage(event));
    }

    @Override
    public void start() {
        Properties transportProperties;
        GlobalConfigurationBuilder gConf = GlobalConfigurationBuilder.defaultClusteredBuilder();
        String clusterName = Objects.requireNonNull(this.config.getInfinispanClusterName());
        TransportConfigurationBuilder transport = gConf.transport();
        transport.clusterName(clusterName);
        String tp = this.config.getInfinispanTransportProperties();
        if (tp != null && (transportProperties = SystemConfig.readProperties((String)tp)).size() > 0) {
            transport.withProperties(transportProperties);
        }
        this.manager = new DefaultCacheManager(gConf.build());
        this.manager.defineConfiguration(DIST_EVENTS_CACHE, new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_SYNC).build());
        this.eventsCache = this.manager.getCache(DIST_EVENTS_CACHE, true);
        this.eventsCache.addListener((Object)this);
    }

    @CacheEntryCreated
    @CacheEntryModified
    public void handle(CacheEntryEvent<String, String> event) {
        this.sendMessage(event.getValue());
    }

    @Override
    public void close() {
        try {
            if (this.eventsCache != null) {
                this.eventsCache.removeListener((Object)this);
            }
        }
        finally {
            IoUtil.close((AutoCloseable)this.manager);
        }
    }
}

