/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.notification;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.pnc.common.concurrent.MDCExecutors;
import org.jboss.pnc.spi.notifications.AttachedClient;
import org.jboss.pnc.spi.notifications.MessageCallback;
import org.jboss.pnc.spi.notifications.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultNotifier
implements Notifier {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Set<AttachedClient> attachedClients = new CopyOnWriteArraySet<AttachedClient>();
    private final ScheduledExecutorService scheduler = MDCExecutors.newScheduledThreadPool((int)1);
    private final MessageCallback messageCallback = new MessageCallback(){

        public void successful(AttachedClient attachedClient) {
        }

        public void failed(AttachedClient attachedClient, Throwable throwable) {
            logger.error("Notification client threw an error, removing it", throwable);
            DefaultNotifier.this.detachClient(attachedClient);
        }
    };

    @PostConstruct
    public void init() {
        this.scheduler.scheduleAtFixedRate(this::cleanUp, 1L, 1L, TimeUnit.HOURS);
    }

    public void attachClient(AttachedClient attachedClient) {
        this.attachedClients.add(attachedClient);
    }

    public void detachClient(AttachedClient attachedClient) {
        this.attachedClients.remove(attachedClient);
    }

    public int getAttachedClientsCount() {
        return this.attachedClients.size();
    }

    public MessageCallback getCallback() {
        return this.messageCallback;
    }

    public void sendMessage(Object message) {
        for (AttachedClient client : this.attachedClients) {
            if (!client.isEnabled()) continue;
            try {
                client.sendMessage(message, this.messageCallback);
            }
            catch (Exception e) {
                logger.error("Unable to send message, detaching client.", (Throwable)e);
                this.detachClient(client);
            }
        }
    }

    public void cleanUp() {
        for (AttachedClient client : this.attachedClients) {
            if (client.isEnabled()) continue;
            this.detachClient(client);
        }
    }
}

