/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.notification;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.jboss.pnc.notification.MessageType;
import org.jboss.pnc.rest.jackson.JacksonProvider;

public class RequestParser {
    private final JacksonProvider mapperProvider = new JacksonProvider();
    private String errorMessage;
    private Response.Status failedStatus;
    MessageType messageType;
    private Object dataObject;

    public boolean parseRequest(String message) throws IOException {
        ObjectMapper mapper = this.mapperProvider.getMapper();
        JsonNode node = null;
        try {
            node = mapper.readTree(message);
        }
        catch (IOException e) {
            this.errorMessage = "Cannot parse request massage.";
            this.failedStatus = Response.Status.BAD_REQUEST;
            throw e;
        }
        if (!node.has("messageType")) {
            this.errorMessage = "Missing 'messageType' field.";
            this.failedStatus = Response.Status.BAD_REQUEST;
            return false;
        }
        if (!node.has("data")) {
            this.errorMessage = "Missing 'data' field.";
            this.failedStatus = Response.Status.BAD_REQUEST;
            return false;
        }
        try {
            this.messageType = MessageType.valueOf(node.get("messageType").asText());
        }
        catch (IllegalArgumentException e) {
            this.errorMessage = "Invalid message-type: " + this.messageType + ". Supported types are: " + MessageType.PROCESS_UPDATES;
            this.failedStatus = Response.Status.NOT_ACCEPTABLE;
            return false;
        }
        try {
            String data = node.get("data").toString();
            this.dataObject = mapper.readValue(data, this.messageType.getType());
            return true;
        }
        catch (IOException e) {
            this.errorMessage = "Cannot parse data part of request massage.";
            this.failedStatus = Response.Status.BAD_REQUEST;
            throw e;
        }
    }

    public <T> T getData() {
        return (T)this.dataObject;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public Response.Status getFailedStatus() {
        return this.failedStatus;
    }

    @Generated
    public MessageType getMessageType() {
        return this.messageType;
    }
}

