/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.environment.openshift;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.jboss.pnc.common.Configuration;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.common.json.moduleconfig.OpenshiftBuildAgentConfig;
import org.jboss.pnc.common.json.moduleprovider.ConfigProvider;
import org.jboss.pnc.common.json.moduleprovider.PncConfigProvider;
import org.jboss.pnc.common.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Configurations {
    PNC_BUILDER_POD("pnc-builder-pod.json"),
    PNC_BUILDER_SERVICE("pnc-builder-service.json"),
    PNC_BUILDER_ROUTE("pnc-builder-route.json"),
    PNC_BUILDER_SSH_SERVICE("pnc-builder-ssh-service.json");

    private static final Logger logger;
    private static final String CONFIGURATIONS_FOLDER = "openshift.configurations/";
    private final String filePath;
    private Configuration configuration;

    private Configurations(String fileName) {
        this.filePath = CONFIGURATIONS_FOLDER + fileName;
        this.configuration = new Configuration();
    }

    public String getContentAsString() {
        String content = this.getContentFromConfigFile();
        if (content == null) {
            try {
                content = IoUtils.readResource((String)this.filePath, (ClassLoader)Configurations.class.getClassLoader());
            }
            catch (IOException e) {
                logger.error("Cannot read configuration file " + this.filePath, (Throwable)e);
                throw new RuntimeException("Could not read configuration file " + this.filePath + ": " + e.getMessage());
            }
        }
        return content;
    }

    private String getContentFromConfigFile() {
        OpenshiftBuildAgentConfig config = null;
        try {
            config = (OpenshiftBuildAgentConfig)this.configuration.getModuleConfig((ConfigProvider)new PncConfigProvider(OpenshiftBuildAgentConfig.class));
        }
        catch (ConfigurationParseException e) {
            logger.warn("Could not parse openshift-build-agent config");
            logger.warn("Either the config is absent, or there's a mistake in the config file");
        }
        String content = null;
        if (config != null) {
            switch (this) {
                case PNC_BUILDER_POD: {
                    content = config.getBuilderPod();
                    break;
                }
                case PNC_BUILDER_SERVICE: {
                    content = config.getPncBuilderService();
                    break;
                }
                case PNC_BUILDER_ROUTE: {
                    content = config.getPncBuilderRoute();
                    break;
                }
                case PNC_BUILDER_SSH_SERVICE: {
                    content = config.getPncBuilderSshRoute();
                }
            }
        }
        return content;
    }

    static {
        logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());
    }
}

