/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.environment.openshift;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.common.Configuration;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.common.json.moduleconfig.OpenshiftEnvironmentDriverModuleConfig;
import org.jboss.pnc.common.json.moduleprovider.ConfigProvider;
import org.jboss.pnc.common.json.moduleprovider.PncConfigProvider;
import org.jboss.pnc.common.monitor.PullingMonitor;
import org.jboss.pnc.common.util.NamedThreadFactory;
import org.jboss.pnc.environment.openshift.OpenshiftStartedEnvironment;
import org.jboss.pnc.model.SystemImageType;
import org.jboss.pnc.spi.builddriver.DebugData;
import org.jboss.pnc.spi.environment.EnvironmentDriver;
import org.jboss.pnc.spi.environment.StartedEnvironment;
import org.jboss.pnc.spi.environment.exception.EnvironmentDriverException;
import org.jboss.pnc.spi.repositorymanager.model.RepositorySession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class OpenshiftEnvironmentDriver
implements EnvironmentDriver {
    private static final Logger logger = LoggerFactory.getLogger(OpenshiftEnvironmentDriver.class);
    public static List<SystemImageType> compatibleImageTypes = Arrays.asList(SystemImageType.DOCKER_IMAGE);
    private ExecutorService executor = Executors.newFixedThreadPool(4, (ThreadFactory)new NamedThreadFactory("openshift-environment-driver"));
    private OpenshiftEnvironmentDriverModuleConfig config;
    private PullingMonitor pullingMonitor;

    @Deprecated
    public OpenshiftEnvironmentDriver() {
    }

    @Inject
    public OpenshiftEnvironmentDriver(Configuration configuration, PullingMonitor pullingMonitor) throws ConfigurationParseException {
        this.pullingMonitor = pullingMonitor;
        this.config = (OpenshiftEnvironmentDriverModuleConfig)configuration.getModuleConfig((ConfigProvider)new PncConfigProvider(OpenshiftEnvironmentDriverModuleConfig.class));
        logger.info("Is OpenShift environment driver disabled: {}", (Object)this.config.isDisabled());
    }

    public StartedEnvironment startEnvironment(String systemImageId, String systemImageRepositoryUrl, SystemImageType systemImageType, RepositorySession repositorySession, DebugData debugData) throws EnvironmentDriverException {
        if (!this.canRunImageType(systemImageType)) {
            throw new UnsupportedOperationException("OpenshiftEnvironmentDriver currently provides support only for the following system image types:" + compatibleImageTypes);
        }
        return new OpenshiftStartedEnvironment(this.executor, this.config, this.pullingMonitor, repositorySession, debugData);
    }

    public boolean canRunImageType(SystemImageType systemImageType) {
        if (this.config.isDisabled()) {
            logger.info("Skipping driver as it is disabled by config.");
            return false;
        }
        return compatibleImageTypes.contains(systemImageType);
    }

    @PreDestroy
    public void destroy() {
        this.executor.shutdownNow();
    }
}

