/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.environment.openshift;

import com.openshift.internal.restclient.model.Pod;
import com.openshift.internal.restclient.model.Route;
import com.openshift.internal.restclient.model.Service;
import com.openshift.internal.restclient.model.properties.ResourcePropertiesRegistry;
import com.openshift.restclient.ClientFactory;
import com.openshift.restclient.IClient;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.NoopSSLCertificateCallback;
import com.openshift.restclient.authorization.IAuthorizationStrategy;
import com.openshift.restclient.authorization.TokenAuthorizationStrategy;
import com.openshift.restclient.model.IResource;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.commons.lang.RandomStringUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.pnc.common.json.moduleconfig.OpenshiftEnvironmentDriverModuleConfig;
import org.jboss.pnc.common.monitor.PullingMonitor;
import org.jboss.pnc.common.util.RandomUtils;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.environment.openshift.Configurations;
import org.jboss.pnc.spi.builddriver.DebugData;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.environment.StartedEnvironment;
import org.jboss.pnc.spi.repositorymanager.model.RepositorySession;
import org.jboss.util.StringPropertyReplacer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftStartedEnvironment
implements StartedEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(OpenshiftStartedEnvironment.class);
    private static final String SSH_SERVICE_PORT_NAME = "2222-ssh";
    private static final String POD_USERNAME = "worker";
    private static final String POD_USER_PASSWD = "workerUserPassword";
    private boolean serviceCreated = false;
    private boolean podCreated = false;
    private boolean routeCreated = false;
    private static final String OSE_API_VERSION = "v1";
    private final IClient client;
    private final RepositorySession repositorySession;
    private final OpenshiftEnvironmentDriverModuleConfig environmentConfiguration;
    private final PullingMonitor pullingMonitor;
    private Pod pod;
    private Service service;
    private Route route;
    private Service sshService;
    private final DebugData debugData;
    private final Set<Selector> initialized = new HashSet<Selector>();
    private final Map<String, String> runtimeProperties;
    private final String buildAgentContextPath;
    private final boolean createRoute;

    public OpenshiftStartedEnvironment(ExecutorService executor, OpenshiftEnvironmentDriverModuleConfig environmentConfiguration, PullingMonitor pullingMonitor, RepositorySession repositorySession, DebugData debugData) {
        logger.info("Creating new build environment using image id: " + environmentConfiguration.getImageId());
        this.environmentConfiguration = environmentConfiguration;
        this.pullingMonitor = pullingMonitor;
        this.repositorySession = repositorySession;
        this.debugData = debugData;
        this.createRoute = environmentConfiguration.getExposeBuildAgentOnPublicUrl();
        this.client = new ClientFactory().create(environmentConfiguration.getRestEndpointUrl(), (ISSLCertificateCallback)new NoopSSLCertificateCallback());
        this.client.setAuthorizationStrategy((IAuthorizationStrategy)new TokenAuthorizationStrategy(environmentConfiguration.getRestAuthToken()));
        this.client.getCurrentUser();
        this.runtimeProperties = new HashMap<String, String>();
        String randString = RandomUtils.randString((int)6);
        this.buildAgentContextPath = "pnc-ba-" + randString;
        String buildAgentHost = environmentConfiguration.getBuildAgentHost();
        this.runtimeProperties.put("build-agent-host", buildAgentHost);
        this.runtimeProperties.put("pod-name", "pnc-ba-pod-" + randString);
        this.runtimeProperties.put("service-name", "pnc-ba-service-" + randString);
        this.runtimeProperties.put("ssh-service-name", "pnc-ba-ssh-" + randString);
        this.runtimeProperties.put("route-name", "pnc-ba-route-" + randString);
        this.runtimeProperties.put("route-path", "/" + this.buildAgentContextPath);
        this.runtimeProperties.put("buildAgentContextPath", "/" + this.buildAgentContextPath);
        this.runtimeProperties.put("containerPort", environmentConfiguration.getContainerPort());
        this.initDebug();
        ModelNode podConfigurationNode = this.createModelNode(Configurations.PNC_BUILDER_POD.getContentAsString(), this.runtimeProperties);
        this.pod = new Pod(podConfigurationNode, this.client, ResourcePropertiesRegistry.getInstance().get(OSE_API_VERSION, "Pod"));
        this.pod.setNamespace(environmentConfiguration.getPncNamespace());
        Runnable createPod = () -> {
            try {
                this.client.create((IResource)this.pod, this.pod.getNamespace());
                this.podCreated = true;
            }
            catch (Throwable e) {
                logger.error("Cannot create pod.", e);
            }
        };
        executor.submit(createPod);
        ModelNode serviceConfigurationNode = this.createModelNode(Configurations.PNC_BUILDER_SERVICE.getContentAsString(), this.runtimeProperties);
        this.service = new Service(serviceConfigurationNode, this.client, ResourcePropertiesRegistry.getInstance().get(OSE_API_VERSION, "Service"));
        this.service.setNamespace(environmentConfiguration.getPncNamespace());
        Runnable createService = () -> {
            try {
                this.client.create((IResource)this.service, this.service.getNamespace());
                this.serviceCreated = true;
            }
            catch (Throwable e) {
                logger.error("Cannot create service.", e);
            }
        };
        executor.submit(createService);
        if (this.createRoute) {
            ModelNode routeConfigurationNode = this.createModelNode(Configurations.PNC_BUILDER_ROUTE.getContentAsString(), this.runtimeProperties);
            this.route = new Route(routeConfigurationNode, this.client, ResourcePropertiesRegistry.getInstance().get(OSE_API_VERSION, "Route"));
            this.route.setNamespace(environmentConfiguration.getPncNamespace());
            Runnable createRoute = () -> {
                try {
                    this.client.create((IResource)this.route, this.route.getNamespace());
                    this.routeCreated = true;
                }
                catch (Throwable e) {
                    logger.error("Cannot create route.", e);
                }
            };
            executor.submit(createRoute);
        }
    }

    private void initDebug() {
        if (this.debugData.isEnableDebugOnFailure()) {
            String password = RandomStringUtils.randomAlphanumeric((int)10);
            this.debugData.setSshPassword(password);
            this.runtimeProperties.put(POD_USER_PASSWD, password);
            this.debugData.setSshServiceInitializer(d -> {
                Integer port = this.startSshService();
                d.setSshCommand("ssh worker@" + this.route.getHost() + " -p " + port);
            });
        }
    }

    private ModelNode createModelNode(String resourceDefinition, Map<String, String> runtimeProperties) {
        String definition = this.replaceConfigurationVariables(resourceDefinition, runtimeProperties);
        logger.info("Node definition: " + definition);
        return ModelNode.fromJSONString((String)definition);
    }

    public void monitorInitialization(Consumer<RunningEnvironment> onComplete, Consumer<Exception> onError) {
        Consumer<RunningEnvironment> onCompleteInternal = runningEnvironment -> {
            logger.info("New build environment available on internal url: {}", (Object)this.getInternalEndpointUrl());
            try {
                Runnable onUrlAvailable = () -> onComplete.accept((RunningEnvironment)runningEnvironment);
                URL url = new URL(this.getInternalEndpointUrl());
                this.pullingMonitor.monitor(onUrlAvailable, onError, () -> this.isServletAvailable(url));
            }
            catch (IOException e) {
                onError.accept(e);
            }
        };
        this.pullingMonitor.monitor(this.onEnvironmentInitComplete(onCompleteInternal, Selector.POD), onError, this::isPodRunning);
        this.pullingMonitor.monitor(this.onEnvironmentInitComplete(onCompleteInternal, Selector.SERVICE), onError, this::isServiceRunning);
        logger.info("Waiting to initialize environment. Pod [{}]; Service [{}].", (Object)this.pod.getName(), (Object)this.service.getName());
        if (this.createRoute) {
            this.pullingMonitor.monitor(this.onEnvironmentInitComplete(onComplete, Selector.ROUTE), onError, this::isRouteRunning);
            logger.info("Route [{}].", (Object)this.route.getName());
        }
    }

    private boolean isServletAvailable(URL servletUrl) {
        try {
            return this.connectToPingUrl(servletUrl);
        }
        catch (IOException e) {
            return false;
        }
    }

    private Runnable onEnvironmentInitComplete(Consumer<RunningEnvironment> onComplete, Selector selector) {
        return () -> {
            OpenshiftStartedEnvironment openshiftStartedEnvironment = this;
            synchronized (openshiftStartedEnvironment) {
                this.initialized.add(selector);
                if (this.createRoute) {
                    if (!this.initialized.containsAll(Arrays.asList(Selector.POD, Selector.SERVICE, Selector.ROUTE))) {
                        return;
                    }
                } else if (!this.initialized.containsAll(Arrays.asList(Selector.POD, Selector.SERVICE))) {
                    return;
                }
            }
            logger.info("Environment successfully initialized. Pod [{}]; Service [{}].", (Object)this.pod.getName(), (Object)this.service.getName());
            if (this.createRoute) {
                logger.info("Route [{}].", (Object)this.route.getName());
            }
            RunningEnvironment runningEnvironment = RunningEnvironment.createInstance((String)this.pod.getName(), (int)Integer.parseInt(this.environmentConfiguration.getContainerPort()), (String)this.route.getHost(), (String)this.getPublicEndpointUrl(), (String)this.getInternalEndpointUrl(), (RepositorySession)this.repositorySession, (Path)Paths.get(this.environmentConfiguration.getWorkingDirectory(), new String[0]), this::destroyEnvironment, (DebugData)this.debugData);
            onComplete.accept(runningEnvironment);
        };
    }

    private String getPublicEndpointUrl() {
        if (this.createRoute) {
            return "http://" + this.route.getHost() + "" + this.route.getPath() + "/" + this.environmentConfiguration.getBuildAgentBindPath();
        }
        return this.getInternalEndpointUrl();
    }

    private String getInternalEndpointUrl() {
        return "http://" + this.service.getPortalIP() + "/" + this.buildAgentContextPath + "/" + this.environmentConfiguration.getBuildAgentBindPath();
    }

    private boolean isPodRunning() {
        if (!this.podCreated) {
            return false;
        }
        this.pod = (Pod)this.client.get(this.pod.getKind(), this.pod.getName(), this.environmentConfiguration.getPncNamespace());
        boolean isRunning = "Running".equals(this.pod.getStatus());
        if (isRunning) {
            logger.debug("Pod {} running.", (Object)this.pod.getName());
            return true;
        }
        return false;
    }

    private boolean isServiceRunning() {
        boolean isRunning;
        if (!this.serviceCreated) {
            return false;
        }
        this.service = (Service)this.client.get(this.service.getKind(), this.service.getName(), this.environmentConfiguration.getPncNamespace());
        boolean bl = isRunning = this.service.getPods().size() > 0;
        if (isRunning) {
            logger.debug("Service {} running.", (Object)this.service.getName());
            return true;
        }
        return false;
    }

    private boolean isRouteRunning() {
        if (!this.routeCreated) {
            return false;
        }
        try {
            if (this.connectToPingUrl(new URL(this.getPublicEndpointUrl()))) {
                this.route = (Route)this.client.get(this.route.getKind(), this.route.getName(), this.environmentConfiguration.getPncNamespace());
                logger.debug("Route {} running.", (Object)this.route.getName());
                return true;
            }
            return false;
        }
        catch (IOException e) {
            logger.error("Cannot open URL " + this.getPublicEndpointUrl(), (Throwable)e);
            return false;
        }
    }

    public String getId() {
        return this.pod.getName();
    }

    public void destroyEnvironment() {
        if (!this.debugData.isDebugEnabled() && !this.environmentConfiguration.getKeepBuildAgentInstance()) {
            if (this.createRoute) {
                this.client.delete((IResource)this.route);
            }
            this.client.delete((IResource)this.service);
            if (this.sshService != null) {
                this.client.delete((IResource)this.sshService);
            }
            this.client.delete((IResource)this.pod);
        }
    }

    private String replaceConfigurationVariables(String podConfiguration, Map runtimeProperties) {
        Boolean proxyActive = !StringUtils.isEmpty((String)this.environmentConfiguration.getProxyServer()) && !StringUtils.isEmpty((String)this.environmentConfiguration.getProxyPort());
        Properties properties = new Properties();
        properties.put("image", this.environmentConfiguration.getImageId());
        properties.put("containerPort", this.environmentConfiguration.getContainerPort());
        properties.put("firewallAllowedDestinations", this.environmentConfiguration.getFirewallAllowedDestinations());
        properties.put("isHttpActive", proxyActive.toString().toLowerCase());
        properties.put("proxyServer", this.environmentConfiguration.getProxyServer());
        properties.put("proxyPort", this.environmentConfiguration.getProxyPort());
        properties.put("proxyUsername", this.repositorySession.getBuildRepositoryId());
        properties.put("nonProxyHosts", this.environmentConfiguration.getNonProxyHosts());
        properties.put("AProxDependencyUrl", this.repositorySession.getConnectionInfo().getDependencyUrl());
        properties.put("AProxDeployUrl", this.repositorySession.getConnectionInfo().getDeployUrl());
        properties.putAll((Map<?, ?>)runtimeProperties);
        return StringPropertyReplacer.replaceProperties((String)podConfiguration, (Properties)properties);
    }

    private Integer startSshService() {
        ModelNode serviceConfigurationNode = this.createModelNode(Configurations.PNC_BUILDER_SSH_SERVICE.getContentAsString(), this.runtimeProperties);
        this.sshService = new Service(serviceConfigurationNode, this.client, ResourcePropertiesRegistry.getInstance().get(OSE_API_VERSION, "Service"));
        this.sshService.setNamespace(this.environmentConfiguration.getPncNamespace());
        try {
            Service resultService = (Service)this.client.create((IResource)this.sshService, this.sshService.getNamespace());
            return resultService.getNode().get("spec").get("ports").asList().stream().filter(m -> m.get("name").asString().equals(SSH_SERVICE_PORT_NAME)).findAny().orElseThrow(() -> new RuntimeException("No ssh service in response! Service data: " + this.describeService(resultService))).get("nodePort").asInt();
        }
        catch (Throwable e) {
            logger.error("Cannot create service.", e);
            return null;
        }
    }

    private String describeService(Service resultService) {
        if (resultService == null) {
            return null;
        }
        ModelNode node = resultService.getNode();
        return "Service[name = " + resultService.getName() + ", node= '" + (node == null ? null : node.toJSONString(false)) + "]";
    }

    private boolean connectToPingUrl(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(500);
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.connect();
        int responseCode = connection.getResponseCode();
        connection.disconnect();
        logger.debug("Got {} from {}.", (Object)responseCode, (Object)url);
        return responseCode == 200;
    }

    private static enum Selector {
        POD,
        SERVICE,
        ROUTE;

    }
}

