/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.environment.openshift;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.common.Configuration;
import org.jboss.pnc.common.concurrent.MDCExecutors;
import org.jboss.pnc.common.concurrent.NamedThreadFactory;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.common.json.moduleconfig.OpenshiftBuildAgentConfig;
import org.jboss.pnc.common.json.moduleconfig.OpenshiftEnvironmentDriverModuleConfig;
import org.jboss.pnc.common.json.moduleprovider.ConfigProvider;
import org.jboss.pnc.common.json.moduleprovider.PncConfigProvider;
import org.jboss.pnc.common.monitor.PullingMonitor;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.environment.openshift.OpenshiftStartedEnvironment;
import org.jboss.pnc.model.SystemImageType;
import org.jboss.pnc.pncmetrics.MetricsConfiguration;
import org.jboss.pnc.spi.builddriver.DebugData;
import org.jboss.pnc.spi.environment.EnvironmentDriver;
import org.jboss.pnc.spi.environment.StartedEnvironment;
import org.jboss.pnc.spi.environment.exception.EnvironmentDriverException;
import org.jboss.pnc.spi.repositorymanager.model.RepositorySession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class OpenshiftEnvironmentDriver
implements EnvironmentDriver {
    private static final Logger logger = LoggerFactory.getLogger(OpenshiftEnvironmentDriver.class);
    private static final int DEFAULT_EXECUTOR_THREAD_POOL_SIZE = 4;
    public static List<SystemImageType> compatibleImageTypes = Arrays.asList(SystemImageType.DOCKER_IMAGE);
    private ExecutorService executor;
    private OpenshiftEnvironmentDriverModuleConfig openshiftEnvironmentDriverModuleConfig;
    private OpenshiftBuildAgentConfig openshiftBuildAgentConfig;
    private PullingMonitor pullingMonitor;
    private MetricsConfiguration metricsConfig;

    @Deprecated
    public OpenshiftEnvironmentDriver() {
    }

    @Inject
    public OpenshiftEnvironmentDriver(Configuration configuration, PullingMonitor pullingMonitor, MetricsConfiguration metricsConfig) throws ConfigurationParseException {
        int executorThreadPoolSize = 4;
        this.pullingMonitor = pullingMonitor;
        this.openshiftEnvironmentDriverModuleConfig = (OpenshiftEnvironmentDriverModuleConfig)configuration.getModuleConfig((ConfigProvider)new PncConfigProvider(OpenshiftEnvironmentDriverModuleConfig.class));
        try {
            this.openshiftBuildAgentConfig = (OpenshiftBuildAgentConfig)configuration.getModuleConfig((ConfigProvider)new PncConfigProvider(OpenshiftBuildAgentConfig.class));
        }
        catch (ConfigurationParseException e) {
            logger.warn("OpenshiftBuildAgentConfig is not provided or is broken. Using the default built-in config.");
        }
        String executorThreadPoolSizeStr = this.openshiftEnvironmentDriverModuleConfig.getExecutorThreadPoolSize();
        if (executorThreadPoolSizeStr != null) {
            executorThreadPoolSize = Integer.parseInt(executorThreadPoolSizeStr);
        }
        this.executor = MDCExecutors.newFixedThreadPool((int)executorThreadPoolSize, (ThreadFactory)new NamedThreadFactory("openshift-environment-driver"));
        this.metricsConfig = metricsConfig;
        logger.info("Is OpenShift environment driver disabled: {}", (Object)this.openshiftEnvironmentDriverModuleConfig.isDisabled());
    }

    public StartedEnvironment startEnvironment(String systemImageId, String systemImageRepositoryUrl, SystemImageType systemImageType, RepositorySession repositorySession, DebugData debugData, String accessToken, Map<String, String> parameters) throws EnvironmentDriverException {
        if (!this.canRunImageType(systemImageType)) {
            throw new UnsupportedOperationException("OpenshiftEnvironmentDriver currently provides support only for the following system image types:" + compatibleImageTypes);
        }
        String buildImageId = StringUtils.addEndingSlash((String)systemImageRepositoryUrl) + StringUtils.stripTrailingSlash((String)systemImageId);
        return new OpenshiftStartedEnvironment(this.executor, this.openshiftBuildAgentConfig, this.openshiftEnvironmentDriverModuleConfig, this.pullingMonitor, repositorySession, buildImageId, debugData, accessToken, this.metricsConfig, parameters);
    }

    public boolean canRunImageType(SystemImageType systemImageType) {
        if (this.openshiftEnvironmentDriverModuleConfig.isDisabled()) {
            logger.info("Skipping driver as it is disabled by openshiftEnvironmentDriverModuleConfig.");
            return false;
        }
        return compatibleImageTypes.contains(systemImageType);
    }

    @PreDestroy
    public void destroy() {
        this.executor.shutdownNow();
    }
}

