/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.environment.openshift;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.openshift.internal.restclient.model.Pod;
import com.openshift.internal.restclient.model.Route;
import com.openshift.internal.restclient.model.Service;
import com.openshift.internal.restclient.model.properties.ResourcePropertiesRegistry;
import com.openshift.restclient.ClientBuilder;
import com.openshift.restclient.IClient;
import com.openshift.restclient.NotFoundException;
import com.openshift.restclient.model.IResource;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.lang.RandomStringUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.pnc.common.json.moduleconfig.OpenshiftBuildAgentConfig;
import org.jboss.pnc.common.json.moduleconfig.OpenshiftEnvironmentDriverModuleConfig;
import org.jboss.pnc.common.monitor.PullingMonitor;
import org.jboss.pnc.common.monitor.RunningTask;
import org.jboss.pnc.common.util.RandomUtils;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.environment.openshift.Configurations;
import org.jboss.pnc.environment.openshift.Resource;
import org.jboss.pnc.environment.openshift.exceptions.PodFailedStartException;
import org.jboss.pnc.pncmetrics.GaugeMetric;
import org.jboss.pnc.pncmetrics.MetricsConfiguration;
import org.jboss.pnc.spi.builddriver.DebugData;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.environment.StartedEnvironment;
import org.jboss.pnc.spi.repositorymanager.model.RepositorySession;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.collection.ConcurrentSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftStartedEnvironment
implements StartedEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(OpenshiftStartedEnvironment.class);
    private static final String SSH_SERVICE_PORT_NAME = "2222-ssh";
    private static final String POD_USERNAME = "worker";
    private static final String POD_USER_PASSWD = "workerUserPassword";
    private static final String OSE_API_VERSION = "v1";
    private static final Pattern SECURE_LOG_PATTERN = Pattern.compile("\"name\":\\s*\"accessToken\",\\s*\"value\":\\s*\"\\p{Print}+\"");
    private static final String METRICS_POD_STARTED_KEY = "openshift-environment-driver.started.pod";
    private static final String METRICS_POD_STARTED_ATTEMPTED_KEY = "openshift-environment-driver.started.pod.attempts";
    private static final String METRICS_POD_STARTED_SUCCESS_KEY = "openshift-environment-driver.started.pod.success";
    private static final String METRICS_POD_STARTED_FAILED_KEY = "openshift-environment-driver.started.pod.failed";
    private static final String METRICS_POD_STARTED_RETRY_KEY = "openshift-environment-driver.started.pod.retries";
    private static final String METRICS_POD_STARTED_FAILED_REASON_KEY = "openshift-environment-driver.started.pod.failed_reason";
    private static final int DEFAULT_CREATION_POD_RETRY = 1;
    private int creationPodRetry = 1;
    private static final String[] POD_FAILED_STATUSES = new String[]{"Failed", "Unknown", "CrashLoopBackOff", "ErrImagePull", "ImagePullBackOff"};
    private static final String BUILDER_POD_MEMORY = "BUILDER_POD_MEMORY";
    private final IClient client;
    private final RepositorySession repositorySession;
    private final OpenshiftBuildAgentConfig openshiftBuildAgentConfig;
    private final OpenshiftEnvironmentDriverModuleConfig environmentConfiguration;
    private final PullingMonitor pullingMonitor;
    private final String imageId;
    private final DebugData debugData;
    private final Set<Selector> initialized = new HashSet<Selector>();
    private final Map<String, String> runtimeProperties;
    private final ExecutorService executor;
    private Optional<GaugeMetric> gaugeMetric = Optional.empty();
    private Pod pod;
    private Service service;
    private Route route;
    private Service sshService;
    private ConcurrentSet<RunningTask> runningTaskMonitors = new ConcurrentSet();
    private String buildAgentContextPath;
    private final boolean createRoute;
    private Runnable cancelHook;
    private boolean cancelRequested = false;
    private Optional<CompletableFuture<Void>> creatingPod = Optional.empty();
    private Optional<CompletableFuture<Void>> creatingService = Optional.empty();
    private Optional<CompletableFuture<Void>> creatingRoute = Optional.empty();
    private CompletableFuture<Void> creationCompletableFutures;

    public OpenshiftStartedEnvironment(ExecutorService executor, OpenshiftBuildAgentConfig openshiftBuildAgentConfig, OpenshiftEnvironmentDriverModuleConfig environmentConfiguration, PullingMonitor pullingMonitor, RepositorySession repositorySession, String systemImageId, DebugData debugData, String accessToken, MetricsConfiguration metricsConfiguration, Map<String, String> parameters) {
        if (environmentConfiguration.getCreationPodRetry() != null) {
            try {
                this.creationPodRetry = Integer.parseInt(environmentConfiguration.getCreationPodRetry());
            }
            catch (NumberFormatException e) {
                logger.error("Couldn't parse the value of creation pod retry from the configuration. Using default");
            }
        }
        logger.info("Creating new build environment using image id: " + environmentConfiguration.getImageId());
        this.executor = executor;
        this.openshiftBuildAgentConfig = openshiftBuildAgentConfig;
        this.environmentConfiguration = environmentConfiguration;
        this.pullingMonitor = pullingMonitor;
        this.repositorySession = repositorySession;
        this.imageId = systemImageId == null ? environmentConfiguration.getImageId() : systemImageId;
        this.debugData = debugData;
        if (metricsConfiguration != null) {
            this.gaugeMetric = Optional.of(metricsConfiguration.getGaugeMetric());
        }
        this.createRoute = environmentConfiguration.getExposeBuildAgentOnPublicUrl();
        this.client = new ClientBuilder(environmentConfiguration.getRestEndpointUrl()).usingToken(environmentConfiguration.getRestAuthToken()).build();
        this.client.getServerReadyStatus();
        this.runtimeProperties = new HashMap<String, String>();
        String buildAgentHost = environmentConfiguration.getBuildAgentHost();
        this.runtimeProperties.put("build-agent-host", buildAgentHost);
        this.runtimeProperties.put("containerPort", environmentConfiguration.getContainerPort());
        this.runtimeProperties.put("buildContentId", repositorySession.getBuildRepositoryId());
        this.runtimeProperties.put("accessToken", accessToken);
        this.runtimeProperties.put("resourcesMemory", this.builderPodMemory(environmentConfiguration, parameters));
        this.createEnvironment();
    }

    private void createEnvironment() {
        ArrayList<CompletableFuture<Void>> trackCreationFutures = new ArrayList<CompletableFuture<Void>>();
        String randString = RandomUtils.randString((int)6);
        this.buildAgentContextPath = "pnc-ba-" + randString;
        this.runtimeProperties.put("pod-name", "pnc-ba-pod-" + randString);
        this.runtimeProperties.put("service-name", "pnc-ba-service-" + randString);
        this.runtimeProperties.put("ssh-service-name", "pnc-ba-ssh-" + randString);
        this.runtimeProperties.put("route-name", "pnc-ba-route-" + randString);
        this.runtimeProperties.put("route-path", "/" + this.buildAgentContextPath);
        this.runtimeProperties.put("buildAgentContextPath", "/" + this.buildAgentContextPath);
        this.initDebug();
        ModelNode podConfigurationNode = this.createModelNode(Configurations.getContentAsString(Resource.PNC_BUILDER_POD, this.openshiftBuildAgentConfig), this.runtimeProperties);
        this.pod = new Pod(podConfigurationNode, this.client, ResourcePropertiesRegistry.getInstance().get(OSE_API_VERSION, "Pod"));
        this.pod.setNamespace(this.environmentConfiguration.getPncNamespace());
        Runnable createPod = () -> {
            try {
                this.client.create((IResource)this.pod, this.pod.getNamespace());
            }
            catch (Throwable e) {
                logger.error("Cannot create pod.", e);
                throw e;
            }
        };
        this.creatingPod = Optional.of(CompletableFuture.runAsync(createPod, this.executor));
        trackCreationFutures.add(this.creatingPod.get());
        ModelNode serviceConfigurationNode = this.createModelNode(Configurations.getContentAsString(Resource.PNC_BUILDER_SERVICE, this.openshiftBuildAgentConfig), this.runtimeProperties);
        this.service = new Service(serviceConfigurationNode, this.client, ResourcePropertiesRegistry.getInstance().get(OSE_API_VERSION, "Service"));
        this.service.setNamespace(this.environmentConfiguration.getPncNamespace());
        Runnable createService = () -> {
            try {
                this.client.create((IResource)this.service, this.service.getNamespace());
            }
            catch (Throwable e) {
                logger.error("Cannot create service.", e);
                throw e;
            }
        };
        this.creatingService = Optional.of(CompletableFuture.runAsync(createService, this.executor));
        trackCreationFutures.add(this.creatingService.get());
        if (this.createRoute) {
            ModelNode routeConfigurationNode = this.createModelNode(Configurations.getContentAsString(Resource.PNC_BUILDER_ROUTE, this.openshiftBuildAgentConfig), this.runtimeProperties);
            this.route = new Route(routeConfigurationNode, this.client, ResourcePropertiesRegistry.getInstance().get(OSE_API_VERSION, "Route"));
            this.route.setNamespace(this.environmentConfiguration.getPncNamespace());
            Runnable createRoute = () -> {
                try {
                    this.client.create((IResource)this.route, this.route.getNamespace());
                }
                catch (Throwable e) {
                    logger.error("Cannot create route.", e);
                    throw e;
                }
            };
            this.creatingRoute = Optional.of(CompletableFuture.runAsync(createRoute, this.executor));
            trackCreationFutures.add(this.creatingRoute.get());
        }
        this.creationCompletableFutures = CompletableFuture.allOf(trackCreationFutures.toArray(new CompletableFuture[0]));
        this.gaugeMetric.ifPresent(g -> g.incrementMetric(METRICS_POD_STARTED_ATTEMPTED_KEY));
    }

    private String builderPodMemory(OpenshiftEnvironmentDriverModuleConfig environmentConfiguration1, Map<String, String> parameters) {
        double builderPodMemory = environmentConfiguration1.getBuilderPodMemory();
        String builderPodMemoryOverride = parameters.get(BUILDER_POD_MEMORY);
        if (builderPodMemoryOverride != null) {
            try {
                builderPodMemory = Double.parseDouble(builderPodMemoryOverride);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Failed to parse memory size '" + builderPodMemoryOverride + "' from " + BUILDER_POD_MEMORY + " parameter.", ex);
            }
            logger.info("Using override for builder pod memory size: " + builderPodMemoryOverride);
        }
        return (int)Math.ceil(builderPodMemory * 1024.0) + "Mi";
    }

    static String secureLog(String message) {
        return SECURE_LOG_PATTERN.matcher(message).replaceAll("\"name\": \"accessToken\",\n            \"value\": \"***\"");
    }

    private void initDebug() {
        if (this.debugData.isEnableDebugOnFailure()) {
            String password = RandomStringUtils.randomAlphanumeric((int)10);
            this.debugData.setSshPassword(password);
            this.runtimeProperties.put(POD_USER_PASSWD, password);
            this.debugData.setSshServiceInitializer(d -> {
                Integer port = this.startSshService();
                d.setSshCommand("ssh worker@" + this.route.getHost() + " -p " + port);
            });
        }
    }

    private ModelNode createModelNode(String resourceDefinition, Map<String, String> runtimeProperties) {
        String definition = this.replaceConfigurationVariables(resourceDefinition, runtimeProperties);
        if (logger.isTraceEnabled()) {
            logger.trace("Node definition: " + OpenshiftStartedEnvironment.secureLog(definition));
        }
        return ModelNode.fromJSONString((String)definition);
    }

    private void retryPod(Exception e, Consumer<RunningEnvironment> onComplete, Consumer<Exception> onError, int retries) {
        this.gaugeMetric.ifPresent(g -> g.incrementMetric(METRICS_POD_STARTED_FAILED_KEY));
        logger.debug("Cancelling existing monitors for this build environment");
        this.cancelAndClearMonitors();
        if (retries == 0) {
            onError.accept(e);
        } else {
            logger.error("Creating build environment failed! Retrying...");
            this.gaugeMetric.ifPresent(g -> g.incrementMetric(METRICS_POD_STARTED_RETRY_KEY));
            Route routeToDestroy = this.route;
            Service serviceToDestroy = this.service;
            Service sshServiceToDestroy = this.sshService;
            Pod podToDestroy = this.pod;
            this.executor.submit(() -> {
                try {
                    logger.debug("Destroying old build environment");
                    this.destroyEnvironment(routeToDestroy, serviceToDestroy, sshServiceToDestroy, podToDestroy, true);
                }
                catch (Exception ex) {
                    logger.error("Error deleting previous environment", (Throwable)ex);
                }
            });
            logger.debug("Creating new build environment");
            this.createEnvironment();
            this.monitorInitialization(onComplete, onError, retries - 1);
        }
    }

    public void monitorInitialization(Consumer<RunningEnvironment> onComplete, Consumer<Exception> onError) {
        this.monitorInitialization(onComplete, onError, this.creationPodRetry);
    }

    private void monitorInitialization(Consumer<RunningEnvironment> onComplete, Consumer<Exception> onError, int retries) {
        Consumer<RunningEnvironment> onCompleteInternal = runningEnvironment -> {
            logger.info("New build environment available on internal url: {}", (Object)this.getInternalEndpointUrl());
            try {
                Runnable onUrlAvailable = () -> onComplete.accept((RunningEnvironment)runningEnvironment);
                URL url = new URL(this.getInternalEndpointUrl());
                this.addMonitors(this.pullingMonitor.monitor(onUrlAvailable, onError, () -> this.isServletAvailable(url)));
            }
            catch (IOException e) {
                onError.accept(e);
            }
        };
        Consumer<Exception> onErrorInternal = exception -> {
            this.cancelAndClearMonitors();
            onError.accept((Exception)exception);
        };
        this.cancelHook = () -> onComplete.accept(null);
        this.creatingPod.ifPresent(f -> f.thenRunAsync(() -> this.addMonitors(this.pullingMonitor.monitor(this.onEnvironmentInitComplete(onCompleteInternal, Selector.POD), t -> this.retryPod((Exception)t, onComplete, onError, retries), this::isPodRunning))));
        this.creatingService.ifPresent(f -> f.thenRunAsync(() -> this.addMonitors(this.pullingMonitor.monitor(this.onEnvironmentInitComplete(onCompleteInternal, Selector.SERVICE), onErrorInternal, this::isServiceRunning))));
        logger.info("Waiting to initialize environment. Pod [{}]; Service [{}].", (Object)this.pod.getName(), (Object)this.service.getName());
        this.creatingRoute.ifPresent(f -> f.thenRunAsync(() -> {
            this.addMonitors(this.pullingMonitor.monitor(this.onEnvironmentInitComplete(onCompleteInternal, Selector.ROUTE), onErrorInternal, this::isRouteRunning));
            logger.info("Route [{}].", (Object)this.route.getName());
        }));
        this.addMonitors(this.pullingMonitor.monitor(() -> {}, onErrorInternal, this::checkOpenshiftObjectCreation));
    }

    private void addMonitors(RunningTask task) {
        this.runningTaskMonitors.add((Object)task);
    }

    private void cancelAndClearMonitors() {
        this.runningTaskMonitors.stream().forEach(arg_0 -> ((PullingMonitor)this.pullingMonitor).cancelRunningTask(arg_0));
        this.runningTaskMonitors.clear();
    }

    private boolean isServletAvailable(URL servletUrl) {
        try {
            return this.connectToPingUrl(servletUrl);
        }
        catch (IOException e) {
            return false;
        }
    }

    private Runnable onEnvironmentInitComplete(Consumer<RunningEnvironment> onComplete, Selector selector) {
        return () -> {
            OpenshiftStartedEnvironment openshiftStartedEnvironment = this;
            synchronized (openshiftStartedEnvironment) {
                this.initialized.add(selector);
                if (this.createRoute) {
                    if (!this.initialized.containsAll(Arrays.asList(Selector.POD, Selector.SERVICE, Selector.ROUTE))) {
                        return;
                    }
                } else if (!this.initialized.containsAll(Arrays.asList(Selector.POD, Selector.SERVICE))) {
                    return;
                }
            }
            logger.info("Environment successfully initialized. Pod [{}]; Service [{}].", (Object)this.pod.getName(), (Object)this.service.getName());
            if (this.createRoute) {
                logger.info("Route initialized [{}].", (Object)this.route.getName());
            }
            RunningEnvironment runningEnvironment = RunningEnvironment.createInstance((String)this.pod.getName(), (int)Integer.parseInt(this.environmentConfiguration.getContainerPort()), (String)this.route.getHost(), (String)this.getPublicEndpointUrl(), (String)this.getInternalEndpointUrl(), (RepositorySession)this.repositorySession, (Path)Paths.get(this.environmentConfiguration.getWorkingDirectory(), new String[0]), this::destroyEnvironment, (DebugData)this.debugData);
            this.gaugeMetric.ifPresent(g -> g.incrementMetric(METRICS_POD_STARTED_SUCCESS_KEY));
            onComplete.accept(runningEnvironment);
        };
    }

    private String getPublicEndpointUrl() {
        if (this.createRoute) {
            return "http://" + this.route.getHost() + "" + this.route.getPath() + "/" + this.environmentConfiguration.getBuildAgentBindPath();
        }
        return this.getInternalEndpointUrl();
    }

    private String getInternalEndpointUrl() {
        return "http://" + this.service.getClusterIP() + "/" + this.buildAgentContextPath + "/" + this.environmentConfiguration.getBuildAgentBindPath();
    }

    private boolean checkOpenshiftObjectCreation() {
        if (!this.creationCompletableFutures.isDone()) {
            logger.debug("All openshift creating completable futures not done yet!");
            return false;
        }
        if (this.creationCompletableFutures.isCompletedExceptionally()) {
            try {
                this.creationCompletableFutures.join();
            }
            catch (Exception e) {
                logger.debug("Exception in one of the openshift creating completable future", (Throwable)e);
                throw new PodFailedStartException(e.getMessage());
            }
            return false;
        }
        return true;
    }

    private boolean isPodRunning() {
        this.pod = (Pod)this.client.get(this.pod.getKind(), this.pod.getName(), this.environmentConfiguration.getPncNamespace());
        String podStatus = this.pod.getStatus();
        logger.debug("Pod {} status: {}", (Object)this.pod.getName(), (Object)podStatus);
        if (Arrays.asList(POD_FAILED_STATUSES).contains(podStatus)) {
            this.gaugeMetric.ifPresent(g -> g.incrementMetric("openshift-environment-driver.started.pod.failed_reason." + podStatus));
            throw new PodFailedStartException("Pod failed with status: " + podStatus);
        }
        boolean isRunning = "Running".equals(this.pod.getStatus());
        if (isRunning) {
            logger.debug("Pod {} running.", (Object)this.pod.getName());
            return true;
        }
        return false;
    }

    private boolean isServiceRunning() {
        boolean isRunning;
        this.service = (Service)this.client.get(this.service.getKind(), this.service.getName(), this.environmentConfiguration.getPncNamespace());
        boolean bl = isRunning = this.service.getPods().size() > 0;
        if (isRunning) {
            logger.debug("Service {} running.", (Object)this.service.getName());
            return true;
        }
        return false;
    }

    private boolean isRouteRunning() {
        try {
            if (this.connectToPingUrl(new URL(this.getPublicEndpointUrl()))) {
                this.route = (Route)this.client.get(this.route.getKind(), this.route.getName(), this.environmentConfiguration.getPncNamespace());
                logger.debug("Route {} running.", (Object)this.route.getName());
                return true;
            }
            return false;
        }
        catch (IOException e) {
            logger.error("Cannot open URL " + this.getPublicEndpointUrl(), (Throwable)e);
            return false;
        }
    }

    public String getId() {
        return this.pod.getName();
    }

    public void cancel() {
        this.cancelRequested = true;
        this.creatingPod.ifPresent(f -> f.cancel(false));
        this.creatingService.ifPresent(f -> f.cancel(false));
        this.creatingRoute.ifPresent(f -> f.cancel(false));
        if (this.cancelHook != null) {
            this.cancelHook.run();
        } else {
            logger.warn("Trying to cancel operation while no cancel hook is defined.");
        }
        this.destroyEnvironment();
    }

    public void destroyEnvironment() {
        this.destroyEnvironment(this.route, this.service, this.sshService, this.pod, false);
    }

    private void destroyEnvironment(Route routeLocal, Service serviceLocal, Service sshServiceLocal, Pod podLocal, boolean force) {
        if (!(this.debugData.isDebugEnabled() && !force || this.environmentConfiguration.getKeepBuildAgentInstance())) {
            if (this.createRoute) {
                this.tryOpenshiftDeleteResource(routeLocal);
            }
            this.tryOpenshiftDeleteResource(serviceLocal);
            if (this.sshService != null) {
                this.tryOpenshiftDeleteResource(sshServiceLocal);
            }
            this.tryOpenshiftDeleteResource(podLocal);
        }
    }

    private <T extends IResource> void tryOpenshiftDeleteResource(T resource) {
        try {
            this.client.delete(resource);
        }
        catch (NotFoundException e) {
            logger.warn("Couldn't delete the Openshift resource since it does not exist", (Throwable)e);
        }
    }

    private String replaceConfigurationVariables(String podConfiguration, Map runtimeProperties) {
        Boolean proxyActive = !StringUtils.isEmpty((String)this.environmentConfiguration.getProxyServer()) && !StringUtils.isEmpty((String)this.environmentConfiguration.getProxyPort());
        Properties properties = new Properties();
        properties.put("image", this.imageId);
        properties.put("containerPort", this.environmentConfiguration.getContainerPort());
        properties.put("firewallAllowedDestinations", this.environmentConfiguration.getFirewallAllowedDestinations());
        properties.put("allowedHttpOutgoingDestinations", this.toEscapedJsonString(this.environmentConfiguration.getAllowedHttpOutgoingDestinations()));
        properties.put("isHttpActive", proxyActive.toString().toLowerCase());
        properties.put("proxyServer", this.environmentConfiguration.getProxyServer());
        properties.put("proxyPort", this.environmentConfiguration.getProxyPort());
        properties.put("nonProxyHosts", this.environmentConfiguration.getNonProxyHosts());
        properties.put("AProxDependencyUrl", this.repositorySession.getConnectionInfo().getDependencyUrl());
        properties.put("AProxDeployUrl", this.repositorySession.getConnectionInfo().getDeployUrl());
        properties.putAll((Map<?, ?>)runtimeProperties);
        return StringPropertyReplacer.replaceProperties((String)podConfiguration, (Properties)properties);
    }

    private Integer startSshService() {
        ModelNode serviceConfigurationNode = this.createModelNode(Configurations.getContentAsString(Resource.PNC_BUILDER_SSH_SERVICE, this.openshiftBuildAgentConfig), this.runtimeProperties);
        this.sshService = new Service(serviceConfigurationNode, this.client, ResourcePropertiesRegistry.getInstance().get(OSE_API_VERSION, "Service"));
        this.sshService.setNamespace(this.environmentConfiguration.getPncNamespace());
        try {
            Service resultService = (Service)this.client.create((IResource)this.sshService, this.sshService.getNamespace());
            return resultService.getNode().get("spec").get("ports").asList().stream().filter(m -> m.get("name").asString().equals(SSH_SERVICE_PORT_NAME)).findAny().orElseThrow(() -> new RuntimeException("No ssh service in response! Service data: " + this.describeService(resultService))).get("nodePort").asInt();
        }
        catch (Throwable e) {
            logger.error("Cannot create service.", e);
            return null;
        }
    }

    private String describeService(Service resultService) {
        if (resultService == null) {
            return null;
        }
        ModelNode node = resultService.getNode();
        return "Service[name = " + resultService.getName() + ", node= '" + (node == null ? null : node.toJSONString(false)) + "]";
    }

    private boolean connectToPingUrl(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(500);
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.connect();
        int responseCode = connection.getResponseCode();
        connection.disconnect();
        logger.debug("Got {} from {}.", (Object)responseCode, (Object)url);
        return responseCode == 200;
    }

    private String toEscapedJsonString(Object object) {
        ObjectMapper mapper = new ObjectMapper();
        JsonStringEncoder jsonStringEncoder = JsonStringEncoder.getInstance();
        try {
            return new String(jsonStringEncoder.quoteAsString(mapper.writeValueAsString(object)));
        }
        catch (JsonProcessingException e) {
            logger.error("Could not parse object: " + object, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static enum Selector {
        POD,
        SERVICE,
        ROUTE;

    }
}

