/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.environment.openshift;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.openshift.internal.restclient.model.Pod;
import com.openshift.internal.restclient.model.Route;
import com.openshift.internal.restclient.model.Service;
import com.openshift.internal.restclient.model.properties.ResourcePropertiesRegistry;
import com.openshift.restclient.ClientBuilder;
import com.openshift.restclient.IClient;
import com.openshift.restclient.NotFoundException;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IResource;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.lang.RandomStringUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.pnc.common.json.moduleconfig.OpenshiftBuildAgentConfig;
import org.jboss.pnc.common.json.moduleconfig.OpenshiftEnvironmentDriverModuleConfig;
import org.jboss.pnc.common.logging.MDCUtils;
import org.jboss.pnc.common.monitor.CancellableCompletableFuture;
import org.jboss.pnc.common.monitor.PollingMonitor;
import org.jboss.pnc.common.util.RandomUtils;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.environment.openshift.Configurations;
import org.jboss.pnc.environment.openshift.Resource;
import org.jboss.pnc.environment.openshift.exceptions.PodFailedStartException;
import org.jboss.pnc.pncmetrics.GaugeMetric;
import org.jboss.pnc.pncmetrics.MetricsConfiguration;
import org.jboss.pnc.spi.builddriver.DebugData;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.environment.StartedEnvironment;
import org.jboss.pnc.spi.repositorymanager.model.RepositorySession;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.collection.ConcurrentSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftStartedEnvironment
implements StartedEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(OpenshiftStartedEnvironment.class);
    private static final String SSH_SERVICE_PORT_NAME = "2222-ssh";
    private static final String POD_USERNAME = "worker";
    private static final String POD_USER_PASSWD = "workerUserPassword";
    private static final String OSE_API_VERSION = "v1";
    private static final Pattern SECURE_LOG_PATTERN = Pattern.compile("\"name\":\\s*\"accessToken\",\\s*\"value\":\\s*\"\\p{Print}+\"");
    private static final String METRICS_POD_STARTED_KEY = "openshift-environment-driver.started.pod";
    private static final String METRICS_POD_STARTED_ATTEMPTED_KEY = "openshift-environment-driver.started.pod.attempts";
    private static final String METRICS_POD_STARTED_SUCCESS_KEY = "openshift-environment-driver.started.pod.success";
    private static final String METRICS_POD_STARTED_FAILED_KEY = "openshift-environment-driver.started.pod.failed";
    private static final String METRICS_POD_STARTED_RETRY_KEY = "openshift-environment-driver.started.pod.retries";
    private static final String METRICS_POD_STARTED_FAILED_REASON_KEY = "openshift-environment-driver.started.pod.failed_reason";
    private static final int DEFAULT_CREATION_POD_RETRY = 1;
    private int creationPodRetry = 1;
    private static final String[] POD_FAILED_STATUSES = new String[]{"Failed", "Unknown", "CrashLoopBackOff", "ErrImagePull", "ImagePullBackOff"};
    private static final String BUILDER_POD_MEMORY = "BUILDER_POD_MEMORY";
    private final IClient client;
    private final RepositorySession repositorySession;
    private final OpenshiftBuildAgentConfig openshiftBuildAgentConfig;
    private final OpenshiftEnvironmentDriverModuleConfig environmentConfiguration;
    private final PollingMonitor pollingMonitor;
    private final String imageId;
    private final DebugData debugData;
    private final Map<String, String> environmetVariables;
    private final ExecutorService executor;
    private Optional<GaugeMetric> gaugeMetric = Optional.empty();
    private Pod pod;
    private Service service;
    private Route route;
    private Service sshService;
    private ConcurrentSet<CompletableFuture<Void>> runningMonitors = new ConcurrentSet();
    private String buildAgentContextPath;
    private final boolean createRoute;
    private Runnable cancelHook;
    private boolean cancelRequested = false;
    private CompletableFuture<Void> creatingPod;
    private CompletableFuture<Void> creatingService;
    private Optional<CompletableFuture<Void>> creatingRoute = Optional.empty();
    private CompletableFuture<Void> openshiftDefinitions;

    public OpenshiftStartedEnvironment(ExecutorService executor, OpenshiftBuildAgentConfig openshiftBuildAgentConfig, OpenshiftEnvironmentDriverModuleConfig environmentConfiguration, PollingMonitor pollingMonitor, RepositorySession repositorySession, String systemImageId, DebugData debugData, String accessToken, boolean tempBuild, Instant temporaryBuildExpireDate, MetricsConfiguration metricsConfiguration, Map<String, String> parameters) {
        if (environmentConfiguration.getCreationPodRetry() != null) {
            try {
                this.creationPodRetry = Integer.parseInt(environmentConfiguration.getCreationPodRetry());
            }
            catch (NumberFormatException e) {
                logger.error("Couldn't parse the value of creation pod retry from the configuration. Using default");
            }
        }
        logger.info("Creating new build environment using image id: " + environmentConfiguration.getImageId());
        this.executor = executor;
        this.openshiftBuildAgentConfig = openshiftBuildAgentConfig;
        this.environmentConfiguration = environmentConfiguration;
        this.pollingMonitor = pollingMonitor;
        this.repositorySession = repositorySession;
        this.imageId = systemImageId == null ? environmentConfiguration.getImageId() : systemImageId;
        this.debugData = debugData;
        if (metricsConfiguration != null) {
            this.gaugeMetric = Optional.of(metricsConfiguration.getGaugeMetric());
        }
        this.createRoute = environmentConfiguration.getExposeBuildAgentOnPublicUrl();
        this.client = new ClientBuilder(environmentConfiguration.getRestEndpointUrl()).usingToken(environmentConfiguration.getRestAuthToken()).build();
        this.client.getServerReadyStatus();
        this.environmetVariables = new HashMap<String, String>();
        String buildAgentHost = environmentConfiguration.getBuildAgentHost();
        String expiresDateStamp = Long.toString(temporaryBuildExpireDate.toEpochMilli());
        Boolean proxyActive = !StringUtils.isEmpty((String)environmentConfiguration.getProxyServer()) && !StringUtils.isEmpty((String)environmentConfiguration.getProxyPort());
        this.environmetVariables.put("image", this.imageId);
        this.environmetVariables.put("firewallAllowedDestinations", environmentConfiguration.getFirewallAllowedDestinations());
        this.environmetVariables.put("allowedHttpOutgoingDestinations", this.toEscapedJsonString(environmentConfiguration.getAllowedHttpOutgoingDestinations()));
        this.environmetVariables.put("isHttpActive", proxyActive.toString().toLowerCase());
        this.environmetVariables.put("proxyServer", environmentConfiguration.getProxyServer());
        this.environmetVariables.put("proxyPort", environmentConfiguration.getProxyPort());
        this.environmetVariables.put("nonProxyHosts", environmentConfiguration.getNonProxyHosts());
        this.environmetVariables.put("AProxDependencyUrl", repositorySession.getConnectionInfo().getDependencyUrl());
        this.environmetVariables.put("AProxDeployUrl", repositorySession.getConnectionInfo().getDeployUrl());
        this.environmetVariables.put("build-agent-host", buildAgentHost);
        this.environmetVariables.put("containerPort", environmentConfiguration.getContainerPort());
        this.environmetVariables.put("buildContentId", repositorySession.getBuildRepositoryId());
        this.environmetVariables.put("accessToken", accessToken);
        this.environmetVariables.put("tempBuild", Boolean.toString(tempBuild));
        this.environmetVariables.put("expiresDate", "ts" + expiresDateStamp);
        MDCUtils.getUserId().ifPresent(v -> this.environmetVariables.put("logUserId", (String)v));
        MDCUtils.getProcessContext().ifPresent(v -> this.environmetVariables.put("logProcessContext", (String)v));
        this.environmetVariables.put("resourcesMemory", this.builderPodMemory(environmentConfiguration, parameters));
        this.createEnvironment();
    }

    private void createEnvironment() {
        String randString = RandomUtils.randString((int)6);
        this.buildAgentContextPath = "pnc-ba-" + randString;
        this.environmetVariables.put("pod-name", "pnc-ba-pod-" + randString);
        this.environmetVariables.put("service-name", "pnc-ba-service-" + randString);
        this.environmetVariables.put("ssh-service-name", "pnc-ba-ssh-" + randString);
        this.environmetVariables.put("route-name", "pnc-ba-route-" + randString);
        this.environmetVariables.put("route-path", "/" + this.buildAgentContextPath);
        this.environmetVariables.put("buildAgentContextPath", "/" + this.buildAgentContextPath);
        this.initDebug();
        ModelNode podConfigurationNode = this.createModelNode(Configurations.getContentAsString(Resource.PNC_BUILDER_POD, this.openshiftBuildAgentConfig), this.environmetVariables);
        this.pod = new Pod(podConfigurationNode, this.client, ResourcePropertiesRegistry.getInstance().get(OSE_API_VERSION, "Pod"));
        this.pod.setNamespace(this.environmentConfiguration.getPncNamespace());
        Runnable createPod = () -> {
            try {
                this.client.create((IResource)this.pod, this.pod.getNamespace());
            }
            catch (Throwable e) {
                logger.error("Cannot create pod.", e);
                throw e;
            }
        };
        this.creatingPod = CompletableFuture.runAsync(createPod, this.executor);
        ModelNode serviceConfigurationNode = this.createModelNode(Configurations.getContentAsString(Resource.PNC_BUILDER_SERVICE, this.openshiftBuildAgentConfig), this.environmetVariables);
        this.service = new Service(serviceConfigurationNode, this.client, ResourcePropertiesRegistry.getInstance().get(OSE_API_VERSION, "Service"));
        this.service.setNamespace(this.environmentConfiguration.getPncNamespace());
        Runnable createService = () -> {
            try {
                this.client.create((IResource)this.service, this.service.getNamespace());
            }
            catch (Throwable e) {
                logger.error("Cannot create service.", e);
                throw e;
            }
        };
        this.creatingService = CompletableFuture.runAsync(createService, this.executor);
        if (this.createRoute) {
            ModelNode routeConfigurationNode = this.createModelNode(Configurations.getContentAsString(Resource.PNC_BUILDER_ROUTE, this.openshiftBuildAgentConfig), this.environmetVariables);
            this.route = new Route(routeConfigurationNode, this.client, ResourcePropertiesRegistry.getInstance().get(OSE_API_VERSION, "Route"));
            this.route.setNamespace(this.environmentConfiguration.getPncNamespace());
            Runnable createRoute = () -> {
                try {
                    this.client.create((IResource)this.route, this.route.getNamespace());
                }
                catch (Throwable e) {
                    logger.error("Cannot create route.", e);
                    throw e;
                }
            };
            CompletableFuture<Void> creatingRouteFuture = CompletableFuture.runAsync(createRoute, this.executor);
            this.creatingRoute = Optional.of(creatingRouteFuture);
            this.openshiftDefinitions = CompletableFuture.allOf(this.creatingPod, this.creatingService, creatingRouteFuture);
        } else {
            this.openshiftDefinitions = CompletableFuture.allOf(this.creatingPod, this.creatingService);
        }
        this.gaugeMetric.ifPresent(g -> g.incrementMetric(METRICS_POD_STARTED_ATTEMPTED_KEY));
    }

    private String builderPodMemory(OpenshiftEnvironmentDriverModuleConfig environmentConfiguration1, Map<String, String> parameters) {
        double builderPodMemory = environmentConfiguration1.getBuilderPodMemory();
        String builderPodMemoryOverride = parameters.get(BUILDER_POD_MEMORY);
        if (builderPodMemoryOverride != null) {
            try {
                builderPodMemory = Double.parseDouble(builderPodMemoryOverride);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Failed to parse memory size '" + builderPodMemoryOverride + "' from " + BUILDER_POD_MEMORY + " parameter.", ex);
            }
            logger.info("Using override for builder pod memory size: " + builderPodMemoryOverride);
        }
        return (int)Math.ceil(builderPodMemory * 1024.0) + "Mi";
    }

    static String secureLog(String message) {
        return SECURE_LOG_PATTERN.matcher(message).replaceAll("\"name\": \"accessToken\",\n            \"value\": \"***\"");
    }

    private void initDebug() {
        if (this.debugData.isEnableDebugOnFailure()) {
            String password = RandomStringUtils.randomAlphanumeric((int)10);
            this.debugData.setSshPassword(password);
            this.environmetVariables.put(POD_USER_PASSWD, password);
            this.debugData.setSshServiceInitializer(d -> {
                Integer port = this.startSshService();
                d.setSshCommand("ssh worker@" + this.route.getHost() + " -p " + port);
            });
        }
    }

    private ModelNode createModelNode(String resourceDefinition, Map<String, String> runtimeProperties) {
        Properties properties = new Properties();
        properties.putAll(runtimeProperties);
        String definition = StringPropertyReplacer.replaceProperties((String)resourceDefinition, (Properties)properties);
        if (logger.isTraceEnabled()) {
            logger.trace("Node definition: " + OpenshiftStartedEnvironment.secureLog(definition));
        }
        return ModelNode.fromJSONString((String)definition);
    }

    private void retryEnvironment(Consumer<RunningEnvironment> onComplete, Consumer<Exception> onError, int retries) {
        this.gaugeMetric.ifPresent(g -> g.incrementMetric(METRICS_POD_STARTED_FAILED_KEY));
        this.gaugeMetric.ifPresent(g -> g.incrementMetric(METRICS_POD_STARTED_RETRY_KEY));
        Route routeToDestroy = this.route;
        Service serviceToDestroy = this.service;
        Service sshServiceToDestroy = this.sshService;
        Pod podToDestroy = this.pod;
        this.executor.submit(() -> {
            try {
                logger.debug("Destroying old build environment");
                this.destroyEnvironment(routeToDestroy, serviceToDestroy, sshServiceToDestroy, podToDestroy, true);
            }
            catch (Exception ex) {
                logger.error("Error deleting previous environment", (Throwable)ex);
            }
        });
        logger.debug("Creating new build environment");
        this.createEnvironment();
        this.monitorInitialization(onComplete, onError, retries - 1);
    }

    public void monitorInitialization(Consumer<RunningEnvironment> onComplete, Consumer<Exception> onError) {
        this.monitorInitialization(onComplete, onError, this.creationPodRetry);
    }

    private void monitorInitialization(Consumer<RunningEnvironment> onComplete, Consumer<Exception> onError, int retries) {
        URL buildAgentUrl;
        try {
            buildAgentUrl = new URL(this.getInternalEndpointUrl());
        }
        catch (MalformedURLException e) {
            onError.accept(e);
            return;
        }
        this.cancelHook = () -> onComplete.accept(null);
        CompletionStage podFuture = this.creatingPod.thenComposeAsync(nul -> {
            CancellableCompletableFuture monitor = this.pollingMonitor.monitor(() -> this.isPodRunning());
            this.addFuture((CancellableCompletableFuture<Void>)monitor);
            return monitor;
        }, (Executor)this.executor);
        CompletionStage serviceFuture = this.creatingService.thenComposeAsync(nul -> {
            CancellableCompletableFuture monitor = this.pollingMonitor.monitor(() -> this.isServiceRunning());
            this.addFuture((CancellableCompletableFuture<Void>)monitor);
            return monitor;
        }, (Executor)this.executor);
        CompletionStage<Object> routeFuture = this.creatingRoute.isPresent() ? this.creatingRoute.get().thenComposeAsync(nul -> {
            CancellableCompletableFuture monitor = this.pollingMonitor.monitor(() -> this.isRouteRunning());
            this.addFuture((CancellableCompletableFuture<Void>)monitor);
            return monitor;
        }, (Executor)this.executor) : CompletableFuture.completedFuture(null);
        CompletableFuture openshiftDefinitionsError = new CompletableFuture();
        this.openshiftDefinitions.exceptionally(t -> {
            openshiftDefinitionsError.completeExceptionally((Throwable)t);
            return null;
        });
        CancellableCompletableFuture isBuildAgentUpFuture = this.pollingMonitor.monitor(() -> this.isServletAvailable(buildAgentUrl));
        this.addFuture((CancellableCompletableFuture<Void>)isBuildAgentUpFuture);
        CompletionStage runningEnvironmentFuture = ((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{podFuture, serviceFuture, routeFuture}).thenApplyAsync(nul -> isBuildAgentUpFuture)).thenApplyAsync(nul -> RunningEnvironment.createInstance((String)this.pod.getName(), (int)Integer.parseInt(this.environmentConfiguration.getContainerPort()), (String)this.route.getHost(), (String)this.getPublicEndpointUrl(), (String)this.getInternalEndpointUrl(), (RepositorySession)this.repositorySession, (Path)Paths.get(this.environmentConfiguration.getWorkingDirectory(), new String[0]), this::destroyEnvironment, (DebugData)this.debugData), (Executor)this.executor);
        CompletableFuture.anyOf(new CompletableFuture[]{runningEnvironmentFuture, openshiftDefinitionsError}).handle((runningEnvironment, throwable) -> {
            if (throwable != null) {
                this.cancelAndClearMonitors();
                if (retries == 0) {
                    onError.accept(new Exception((Throwable)throwable));
                } else {
                    logger.error("Creating build environment failed! Retrying...", throwable);
                    this.retryEnvironment(onComplete, onError, retries);
                }
            } else {
                logger.info("Environment successfully initialized. Pod [{}]; Service [{}].", (Object)this.pod.getName(), (Object)this.service.getName());
                onComplete.accept((RunningEnvironment)runningEnvironment);
            }
            this.gaugeMetric.ifPresent(g -> g.incrementMetric(METRICS_POD_STARTED_SUCCESS_KEY));
            return null;
        });
        logger.info("Waiting to initialize environment. Pod [{}]; Service [{}].", (Object)this.pod.getName(), (Object)this.service.getName());
    }

    private void addFuture(CancellableCompletableFuture<Void> future) {
        this.runningMonitors.add(future);
    }

    private void cancelAndClearMonitors() {
        logger.debug("Cancelling existing monitors for this build environment");
        this.runningMonitors.stream().forEach(f -> f.cancel(false));
        this.runningMonitors.clear();
    }

    private boolean isServletAvailable(URL servletUrl) {
        try {
            return this.connectToPingUrl(servletUrl);
        }
        catch (IOException e) {
            return false;
        }
    }

    private String getPublicEndpointUrl() {
        if (this.createRoute) {
            return "http://" + this.route.getHost() + "" + this.route.getPath() + "/" + this.environmentConfiguration.getBuildAgentBindPath();
        }
        return this.getInternalEndpointUrl();
    }

    private String getInternalEndpointUrl() {
        return "http://" + this.service.getClusterIP() + "/" + this.buildAgentContextPath + "/" + this.environmentConfiguration.getBuildAgentBindPath();
    }

    private boolean isPodRunning() {
        this.pod = (Pod)this.client.get(this.pod.getKind(), this.pod.getName(), this.environmentConfiguration.getPncNamespace());
        String podStatus = this.pod.getStatus();
        logger.debug("Pod {} status: {}", (Object)this.pod.getName(), (Object)podStatus);
        if (Arrays.asList(POD_FAILED_STATUSES).contains(podStatus)) {
            this.gaugeMetric.ifPresent(g -> g.incrementMetric("openshift-environment-driver.started.pod.failed_reason." + podStatus));
            throw new PodFailedStartException("Pod failed with status: " + podStatus);
        }
        boolean isRunning = "Running".equals(this.pod.getStatus());
        if (isRunning) {
            logger.debug("Pod {} running.", (Object)this.pod.getName());
            return true;
        }
        return false;
    }

    private boolean isServiceRunning() {
        boolean isRunning;
        this.service = (Service)this.client.get(this.service.getKind(), this.service.getName(), this.environmentConfiguration.getPncNamespace());
        boolean bl = isRunning = this.service.getPods().size() > 0;
        if (isRunning) {
            logger.debug("Service {} running.", (Object)this.service.getName());
            return true;
        }
        return false;
    }

    private boolean isRouteRunning() {
        try {
            if (this.connectToPingUrl(new URL(this.getPublicEndpointUrl()))) {
                this.route = (Route)this.client.get(this.route.getKind(), this.route.getName(), this.environmentConfiguration.getPncNamespace());
                logger.debug("Route {} running.", (Object)this.route.getName());
                return true;
            }
            return false;
        }
        catch (IOException e) {
            logger.error("Cannot open URL " + this.getPublicEndpointUrl(), (Throwable)e);
            return false;
        }
    }

    public String getId() {
        return this.pod.getName();
    }

    public void cancel() {
        this.cancelRequested = true;
        this.creatingPod.cancel(false);
        this.creatingService.cancel(false);
        this.creatingRoute.ifPresent(f -> f.cancel(false));
        this.cancelAndClearMonitors();
        if (this.cancelHook != null) {
            this.cancelHook.run();
        } else {
            logger.warn("Trying to cancel operation while no cancel hook is defined.");
        }
        this.destroyEnvironment();
    }

    public void destroyEnvironment() {
        try {
            this.destroyEnvironment(this.route, this.service, this.sshService, this.pod, false);
        }
        catch (OpenShiftException e) {
            logger.error("Could not destroy the environment.", (Throwable)e);
        }
    }

    private void destroyEnvironment(Route routeLocal, Service serviceLocal, Service sshServiceLocal, Pod podLocal, boolean force) {
        if (!(this.debugData.isDebugEnabled() && !force || this.environmentConfiguration.getKeepBuildAgentInstance())) {
            if (this.createRoute) {
                this.tryOpenshiftDeleteResource(routeLocal);
            }
            this.tryOpenshiftDeleteResource(serviceLocal);
            if (this.sshService != null) {
                this.tryOpenshiftDeleteResource(sshServiceLocal);
            }
            this.tryOpenshiftDeleteResource(podLocal);
        }
    }

    private <T extends IResource> void tryOpenshiftDeleteResource(T resource) {
        try {
            this.client.delete(resource);
        }
        catch (NotFoundException e) {
            logger.warn("Couldn't delete the Openshift resource since it does not exist", (Throwable)e);
        }
    }

    private Integer startSshService() {
        ModelNode serviceConfigurationNode = this.createModelNode(Configurations.getContentAsString(Resource.PNC_BUILDER_SSH_SERVICE, this.openshiftBuildAgentConfig), this.environmetVariables);
        this.sshService = new Service(serviceConfigurationNode, this.client, ResourcePropertiesRegistry.getInstance().get(OSE_API_VERSION, "Service"));
        this.sshService.setNamespace(this.environmentConfiguration.getPncNamespace());
        try {
            Service resultService = (Service)this.client.create((IResource)this.sshService, this.sshService.getNamespace());
            return resultService.getNode().get("spec").get("ports").asList().stream().filter(m -> m.get("name").asString().equals(SSH_SERVICE_PORT_NAME)).findAny().orElseThrow(() -> new RuntimeException("No ssh service in response! Service data: " + this.describeService(resultService))).get("nodePort").asInt();
        }
        catch (Throwable e) {
            logger.error("Cannot create service.", e);
            return null;
        }
    }

    private String describeService(Service resultService) {
        if (resultService == null) {
            return null;
        }
        ModelNode node = resultService.getNode();
        return "Service[name = " + resultService.getName() + ", node= '" + (node == null ? null : node.toJSONString(false)) + "]";
    }

    private boolean connectToPingUrl(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(500);
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.connect();
        int responseCode = connection.getResponseCode();
        connection.disconnect();
        logger.debug("Got {} from {}.", (Object)responseCode, (Object)url);
        return responseCode == 200;
    }

    private String toEscapedJsonString(Object object) {
        ObjectMapper mapper = new ObjectMapper();
        JsonStringEncoder jsonStringEncoder = JsonStringEncoder.getInstance();
        try {
            return new String(jsonStringEncoder.quoteAsString(mapper.writeValueAsString(object)));
        }
        catch (JsonProcessingException e) {
            logger.error("Could not parse object: " + object, (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

