/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.environment.openshift;

import java.lang.invoke.MethodHandles;
import org.jboss.pnc.common.json.moduleconfig.OpenshiftBuildAgentConfig;
import org.jboss.pnc.environment.openshift.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configurations {
    private static final Logger logger = LoggerFactory.getLogger((String)MethodHandles.lookup().lookupClass().getName());

    public static String getContentAsString(Resource resource, OpenshiftBuildAgentConfig openshiftBuildAgentConfig) {
        String content = null;
        if (openshiftBuildAgentConfig != null) {
            content = Configurations.getContentFromConfigFile(resource, openshiftBuildAgentConfig);
        }
        if (content == null) {
            content = resource.getDefaultConfiguration();
        }
        return content;
    }

    private static String getContentFromConfigFile(Resource resource, OpenshiftBuildAgentConfig openshiftBuildAgentConfig) {
        String content = null;
        switch (resource) {
            case PNC_BUILDER_POD: {
                content = openshiftBuildAgentConfig.getBuilderPod();
                break;
            }
            case PNC_BUILDER_SERVICE: {
                content = openshiftBuildAgentConfig.getPncBuilderService();
                break;
            }
            case PNC_BUILDER_ROUTE: {
                content = openshiftBuildAgentConfig.getPncBuilderRoute();
                break;
            }
            case PNC_BUILDER_SSH_SERVICE: {
                content = openshiftBuildAgentConfig.getPncBuilderSshRoute();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported resource type: " + resource.toString());
            }
        }
        return content;
    }
}

