/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.environment.openshift;

import java.io.IOException;
import org.jboss.pnc.common.util.IoUtils;
import org.jboss.pnc.environment.openshift.Configurations;

public enum Resource {
    PNC_BUILDER_POD("pnc-builder-pod.json"),
    PNC_BUILDER_SERVICE("pnc-builder-service.json"),
    PNC_BUILDER_ROUTE("pnc-builder-route.json"),
    PNC_BUILDER_SSH_SERVICE("pnc-builder-ssh-service.json");

    private static final String CONFIGURATIONS_FOLDER = "openshift.configurations/";
    private final String filePath;

    private Resource(String fileName) {
        this.filePath = CONFIGURATIONS_FOLDER + fileName;
    }

    public String getDefaultConfiguration() {
        try {
            return IoUtils.readResource((String)this.filePath, (ClassLoader)Configurations.class.getClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read configuration file " + this.filePath + ".", e);
        }
    }
}

