/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.environment.openshift;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.lang.RandomStringUtils;
import org.jboss.pnc.api.constants.BuildConfigurationParameterKeys;
import org.jboss.pnc.common.json.moduleconfig.OpenshiftBuildAgentConfig;
import org.jboss.pnc.common.json.moduleconfig.OpenshiftEnvironmentDriverModuleConfig;
import org.jboss.pnc.common.logging.MDCUtils;
import org.jboss.pnc.common.monitor.CancellableCompletableFuture;
import org.jboss.pnc.common.monitor.PollingMonitor;
import org.jboss.pnc.common.util.CompletableFutureUtils;
import org.jboss.pnc.common.util.RandomUtils;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.environment.openshift.Configurations;
import org.jboss.pnc.environment.openshift.Resource;
import org.jboss.pnc.environment.openshift.exceptions.PodFailedStartException;
import org.jboss.pnc.pncmetrics.GaugeMetric;
import org.jboss.pnc.pncmetrics.MetricsConfiguration;
import org.jboss.pnc.spi.builddriver.DebugData;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.environment.StartedEnvironment;
import org.jboss.pnc.spi.repositorymanager.model.RepositorySession;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.collection.ConcurrentSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftStartedEnvironment
implements StartedEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(OpenshiftStartedEnvironment.class);
    private static final String SSH_SERVICE_PORT_NAME = "2222-ssh";
    private static final String POD_USERNAME = "worker";
    private static final String POD_USER_PASSWD = "workerUserPassword";
    private static final Pattern SECURE_LOG_PATTERN = Pattern.compile("\"name\":\\s*\"accessToken\",\\s*\"value\":\\s*\"\\p{Print}+\"");
    private static final String METRICS_POD_STARTED_KEY = "openshift-environment-driver.started.pod";
    private static final String METRICS_POD_STARTED_ATTEMPTED_KEY = "openshift-environment-driver.started.pod.attempts";
    private static final String METRICS_POD_STARTED_SUCCESS_KEY = "openshift-environment-driver.started.pod.success";
    private static final String METRICS_POD_STARTED_FAILED_KEY = "openshift-environment-driver.started.pod.failed";
    private static final String METRICS_POD_STARTED_RETRY_KEY = "openshift-environment-driver.started.pod.retries";
    private static final String METRICS_POD_STARTED_FAILED_REASON_KEY = "openshift-environment-driver.started.pod.failed_reason";
    private int creationPodRetry;
    private int pollingMonitorTimeout;
    private int pollingMonitorCheckInterval;
    private static final String[] POD_FAILED_STATUSES = new String[]{"Failed", "Unknown", "CrashLoopBackOff", "ErrImagePull", "ImagePullBackOff", "Error", "InvalidImageName", "ContainerCannotRun"};
    private static final String[] POD_RETRYABLE_STATUSES = new String[]{"Failed", "Unknown", "CrashLoopBackOff", "ErrImagePull", "ImagePullBackOff", "Error", "ContainerCannotRun"};
    private final OpenShiftClient client;
    private final ObjectMapper mapper;
    private final RepositorySession repositorySession;
    private final OpenshiftBuildAgentConfig openshiftBuildAgentConfig;
    private final OpenshiftEnvironmentDriverModuleConfig environmentConfiguration;
    private final PollingMonitor pollingMonitor;
    private final String imageId;
    private final DebugData debugData;
    private final Map<String, String> environmentVariables;
    private final ExecutorService executor;
    private Optional<GaugeMetric> gaugeMetric = Optional.empty();
    private Pod pod;
    private Service service;
    private Route route;
    private Service sshService;
    private ConcurrentSet<CompletableFuture<Void>> runningMonitors = new ConcurrentSet();
    private String buildAgentContextPath;
    private final boolean createRoute;
    private Runnable cancelHook;
    private boolean cancelRequested = false;
    private CompletableFuture<Void> creatingPod;
    private CompletableFuture<Void> creatingService;
    private Optional<CompletableFuture<Void>> creatingRoute = Optional.empty();
    private CompletableFuture<Void> openshiftDefinitions;

    public OpenshiftStartedEnvironment(ExecutorService executor, OpenshiftBuildAgentConfig openshiftBuildAgentConfig, OpenshiftEnvironmentDriverModuleConfig environmentConfiguration, PollingMonitor pollingMonitor, RepositorySession repositorySession, String systemImageId, DebugData debugData, String accessToken, boolean tempBuild, Instant temporaryBuildExpireDate, MetricsConfiguration metricsConfiguration, Map<String, String> parameters) {
        logger.info("Creating new build environment using image id: {}", (Object)environmentConfiguration.getImageId());
        this.creationPodRetry = environmentConfiguration.getCreationPodRetry();
        this.pollingMonitorTimeout = environmentConfiguration.getPollingMonitorTimeout();
        this.pollingMonitorCheckInterval = environmentConfiguration.getPollingMonitorCheckInterval();
        this.executor = executor;
        this.openshiftBuildAgentConfig = openshiftBuildAgentConfig;
        this.environmentConfiguration = environmentConfiguration;
        this.pollingMonitor = pollingMonitor;
        this.repositorySession = repositorySession;
        this.imageId = systemImageId == null ? environmentConfiguration.getImageId() : systemImageId;
        this.debugData = debugData;
        if (metricsConfiguration != null) {
            this.gaugeMetric = Optional.of(metricsConfiguration.getGaugeMetric());
        }
        this.mapper = new ObjectMapper();
        this.createRoute = environmentConfiguration.getExposeBuildAgentOnPublicUrl();
        Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withNamespace(environmentConfiguration.getPncNamespace())).withMasterUrl(environmentConfiguration.getRestEndpointUrl())).withOauthToken(environmentConfiguration.getRestAuthToken())).build();
        this.client = new DefaultOpenShiftClient(config);
        this.environmentVariables = new HashMap<String, String>();
        String buildAgentHost = environmentConfiguration.getBuildAgentHost();
        String expiresDateStamp = Long.toString(temporaryBuildExpireDate.toEpochMilli());
        boolean proxyActive = !StringUtils.isEmpty((String)environmentConfiguration.getProxyServer()) && !StringUtils.isEmpty((String)environmentConfiguration.getProxyPort());
        this.environmentVariables.put("image", this.imageId);
        this.environmentVariables.put("firewallAllowedDestinations", environmentConfiguration.getFirewallAllowedDestinations());
        this.environmentVariables.put("allowedHttpOutgoingDestinations", this.toEscapedJsonString(environmentConfiguration.getAllowedHttpOutgoingDestinations()));
        this.environmentVariables.put("isHttpActive", Boolean.toString(proxyActive).toLowerCase());
        this.environmentVariables.put("proxyServer", environmentConfiguration.getProxyServer());
        this.environmentVariables.put("proxyPort", environmentConfiguration.getProxyPort());
        this.environmentVariables.put("nonProxyHosts", environmentConfiguration.getNonProxyHosts());
        this.environmentVariables.put("AProxDependencyUrl", repositorySession.getConnectionInfo().getDependencyUrl());
        this.environmentVariables.put("AProxDeployUrl", repositorySession.getConnectionInfo().getDeployUrl());
        this.environmentVariables.put("build-agent-host", buildAgentHost);
        this.environmentVariables.put("containerPort", environmentConfiguration.getContainerPort());
        this.environmentVariables.put("buildContentId", repositorySession.getBuildRepositoryId());
        this.environmentVariables.put("accessToken", accessToken);
        this.environmentVariables.put("tempBuild", Boolean.toString(tempBuild));
        this.environmentVariables.put("expiresDate", "ts" + expiresDateStamp);
        MDCUtils.getUserId().ifPresent(v -> this.environmentVariables.put("logUserId", (String)v));
        MDCUtils.getProcessContext().ifPresent(v -> this.environmentVariables.put("logProcessContext", (String)v));
        this.environmentVariables.put("resourcesMemory", this.builderPodMemory(environmentConfiguration, parameters));
        this.createEnvironment();
    }

    private void createEnvironment() {
        String randString = RandomUtils.randString((int)6);
        this.buildAgentContextPath = "pnc-ba-" + randString;
        this.environmentVariables.put("pod-name", "pnc-ba-pod-" + randString);
        this.environmentVariables.put("service-name", "pnc-ba-service-" + randString);
        this.environmentVariables.put("ssh-service-name", "pnc-ba-ssh-" + randString);
        this.environmentVariables.put("route-name", "pnc-ba-route-" + randString);
        this.environmentVariables.put("route-path", "/" + this.buildAgentContextPath);
        this.environmentVariables.put("buildAgentContextPath", "/" + this.buildAgentContextPath);
        this.initDebug();
        Runnable createPod = () -> {
            try {
                Pod podCreationModel = this.createModelNode(Configurations.getContentAsString(Resource.PNC_BUILDER_POD, this.openshiftBuildAgentConfig), this.environmentVariables, Pod.class);
                this.pod = (Pod)this.client.pods().create((Object)podCreationModel);
            }
            catch (Throwable e) {
                logger.error("Cannot create pod.", e);
                throw new RuntimeException(e);
            }
        };
        this.creatingPod = CompletableFuture.runAsync(createPod, this.executor);
        Runnable createService = () -> {
            try {
                Service serviceCreationModel = this.createModelNode(Configurations.getContentAsString(Resource.PNC_BUILDER_SERVICE, this.openshiftBuildAgentConfig), this.environmentVariables, Service.class);
                this.service = (Service)this.client.services().create((Object)serviceCreationModel);
            }
            catch (Throwable e) {
                logger.error("Cannot create service.", e);
                throw e;
            }
        };
        this.creatingService = CompletableFuture.runAsync(createService, this.executor);
        if (this.createRoute) {
            Runnable createRoute = () -> {
                try {
                    Route routeCreationModel = this.createModelNode(Configurations.getContentAsString(Resource.PNC_BUILDER_ROUTE, this.openshiftBuildAgentConfig), this.environmentVariables, Route.class);
                    this.route = (Route)this.client.routes().create((Object)routeCreationModel);
                }
                catch (Throwable e) {
                    logger.error("Cannot create route.", e);
                    throw e;
                }
            };
            CompletableFuture<Void> creatingRouteFuture = CompletableFuture.runAsync(createRoute, this.executor);
            this.creatingRoute = Optional.of(creatingRouteFuture);
            this.openshiftDefinitions = CompletableFuture.allOf(this.creatingPod, this.creatingService, creatingRouteFuture);
        } else {
            this.openshiftDefinitions = CompletableFuture.allOf(this.creatingPod, this.creatingService);
        }
        this.gaugeMetric.ifPresent(g -> g.incrementMetric(METRICS_POD_STARTED_ATTEMPTED_KEY));
    }

    private String builderPodMemory(OpenshiftEnvironmentDriverModuleConfig environmentConfiguration1, Map<String, String> parameters) {
        double builderPodMemory = environmentConfiguration1.getBuilderPodMemory();
        String builderPodMemoryKey = BuildConfigurationParameterKeys.BUILDER_POD_MEMORY.name();
        String builderPodMemoryOverride = parameters.get(builderPodMemoryKey);
        if (builderPodMemoryOverride != null) {
            try {
                builderPodMemory = Double.parseDouble(builderPodMemoryOverride);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Failed to parse memory size '" + builderPodMemoryOverride + "' from " + builderPodMemoryKey + " parameter.", ex);
            }
            logger.info("Using override for builder pod memory size: {}", (Object)builderPodMemoryOverride);
        }
        return (int)Math.ceil(builderPodMemory * 1024.0) + "Mi";
    }

    static String secureLog(String message) {
        return SECURE_LOG_PATTERN.matcher(message).replaceAll("\"name\": \"accessToken\",\n            \"value\": \"***\"");
    }

    private void initDebug() {
        if (this.debugData.isEnableDebugOnFailure()) {
            String password = RandomStringUtils.randomAlphanumeric((int)10);
            this.debugData.setSshPassword(password);
            this.environmentVariables.put(POD_USER_PASSWD, password);
            this.debugData.setSshServiceInitializer(d -> {
                Integer port = this.startSshService();
                d.setSshCommand("ssh worker@" + this.route.getSpec().getHost() + " -p " + port);
            });
        }
    }

    private <T> T createModelNode(String resourceDefinition, Map<String, String> runtimeProperties, Class<T> clazz) {
        Properties properties = new Properties();
        properties.putAll(runtimeProperties);
        String definition = StringPropertyReplacer.replaceProperties((String)resourceDefinition, (Properties)properties);
        if (logger.isTraceEnabled()) {
            logger.trace("Node definition: {}", (Object)OpenshiftStartedEnvironment.secureLog(definition));
        }
        try {
            return (T)this.mapper.readValue(definition, clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private void retryEnvironment(Consumer<RunningEnvironment> onComplete, Consumer<Exception> onError, int retries) {
        this.gaugeMetric.ifPresent(g -> g.incrementMetric(METRICS_POD_STARTED_FAILED_KEY));
        this.gaugeMetric.ifPresent(g -> g.incrementMetric(METRICS_POD_STARTED_RETRY_KEY));
        Route routeToDestroy = this.route;
        Service serviceToDestroy = this.service;
        Service sshServiceToDestroy = this.sshService;
        Pod podToDestroy = this.pod;
        this.executor.submit(() -> {
            try {
                logger.debug("Destroying old build environment");
                this.destroyEnvironment(routeToDestroy, serviceToDestroy, sshServiceToDestroy, podToDestroy, true);
            }
            catch (Exception ex) {
                logger.error("Error deleting previous environment", (Throwable)ex);
            }
        });
        logger.debug("Creating new build environment");
        this.createEnvironment();
        this.monitorInitialization(onComplete, onError, retries - 1);
    }

    public void monitorInitialization(Consumer<RunningEnvironment> onComplete, Consumer<Exception> onError) {
        this.monitorInitialization(onComplete, onError, this.creationPodRetry);
    }

    private void monitorInitialization(Consumer<RunningEnvironment> onComplete, Consumer<Exception> onError, int retries) {
        this.cancelHook = () -> onComplete.accept(null);
        CompletionStage podFuture = this.creatingPod.thenComposeAsync(nul -> {
            CancellableCompletableFuture monitor = this.pollingMonitor.monitor(this::isPodRunning, this.pollingMonitorCheckInterval, this.pollingMonitorTimeout, TimeUnit.SECONDS);
            this.addFuture((CancellableCompletableFuture<Void>)monitor);
            return monitor;
        }, (Executor)this.executor);
        CompletionStage serviceFuture = this.creatingService.thenComposeAsync(nul -> {
            CancellableCompletableFuture monitor = this.pollingMonitor.monitor(this::isServiceRunning, this.pollingMonitorCheckInterval, this.pollingMonitorTimeout, TimeUnit.SECONDS);
            this.addFuture((CancellableCompletableFuture<Void>)monitor);
            return monitor;
        }, (Executor)this.executor);
        CompletionStage<Object> routeFuture = this.creatingRoute.isPresent() ? this.creatingRoute.get().thenComposeAsync(nul -> {
            CancellableCompletableFuture monitor = this.pollingMonitor.monitor(this::isRouteRunning, this.pollingMonitorCheckInterval, this.pollingMonitorTimeout, TimeUnit.SECONDS);
            this.addFuture((CancellableCompletableFuture<Void>)monitor);
            return monitor;
        }, (Executor)this.executor) : CompletableFuture.completedFuture(null);
        CompletableFuture openshiftDefinitionsError = new CompletableFuture();
        this.openshiftDefinitions.exceptionally(t -> {
            openshiftDefinitionsError.completeExceptionally((Throwable)t);
            return null;
        });
        CancellableCompletableFuture isBuildAgentUpFuture = this.pollingMonitor.monitor(this::isInternalServletAvailable, this.pollingMonitorCheckInterval, this.pollingMonitorTimeout, TimeUnit.SECONDS);
        this.addFuture((CancellableCompletableFuture<Void>)isBuildAgentUpFuture);
        CompletionStage runningEnvironmentFuture = ((CompletableFuture)CompletableFutureUtils.allOfOrException((CompletableFuture[])new CompletableFuture[]{podFuture, serviceFuture, routeFuture}).thenComposeAsync(nul -> isBuildAgentUpFuture, (Executor)this.executor)).thenApplyAsync(nul -> RunningEnvironment.createInstance((String)this.pod.getMetadata().getName(), (int)Integer.parseInt(this.environmentConfiguration.getContainerPort()), (String)this.route.getSpec().getHost(), (String)this.getPublicEndpointUrl(), (String)this.getInternalEndpointUrl(), (RepositorySession)this.repositorySession, (Path)Paths.get(this.environmentConfiguration.getWorkingDirectory(), new String[0]), this::destroyEnvironment, (DebugData)this.debugData), (Executor)this.executor);
        CompletableFuture.anyOf(new CompletableFuture[]{runningEnvironmentFuture, openshiftDefinitionsError}).handleAsync((runningEnvironment, throwable) -> {
            if (throwable != null) {
                logger.info("Error while trying to create an OpenShift environment... ", throwable);
                this.cancelAndClearMonitors();
                if (retries == 0) {
                    logger.info("No more retries left, giving up!");
                    onError.accept(new Exception(this.getPrettierErrorMessageFromThrowable((Throwable)throwable, true), (Throwable)throwable));
                } else {
                    PodFailedStartException podFailedStartExc = null;
                    if (throwable instanceof PodFailedStartException) {
                        podFailedStartExc = (PodFailedStartException)throwable;
                    } else if (throwable.getCause() instanceof PodFailedStartException) {
                        podFailedStartExc = (PodFailedStartException)throwable.getCause();
                    }
                    if (podFailedStartExc != null && !Arrays.asList(POD_RETRYABLE_STATUSES).contains(podFailedStartExc.getPodStatus())) {
                        logger.info("The detected pod error status '{}' is not considered among the ones to be retried, giving up!", (Object)podFailedStartExc.getPodStatus());
                        onError.accept(new Exception(this.getPrettierErrorMessageFromThrowable((Throwable)throwable, false), (Throwable)throwable));
                    } else if (!this.cancelRequested) {
                        logger.warn("Creating build environment failed with error '{}'! Retrying ({} retries left)...", throwable, (Object)retries);
                        this.retryEnvironment(onComplete, onError, retries);
                    } else {
                        logger.info("Build was cancelled, not retrying environment!");
                    }
                }
            } else {
                logger.info("Environment successfully initialized. Pod [{}]; Service [{}].", (Object)this.pod.getMetadata().getName(), (Object)this.service.getMetadata().getName());
                onComplete.accept((RunningEnvironment)runningEnvironment);
            }
            this.gaugeMetric.ifPresent(g -> g.incrementMetric(METRICS_POD_STARTED_SUCCESS_KEY));
            return null;
        }, (Executor)this.executor);
    }

    private String getPrettierErrorMessageFromThrowable(Throwable throwable, boolean finishedRetries) {
        String errMsg = "Some errors occurred while trying to create a build environment where to run the build.";
        if (throwable instanceof TimeoutException || throwable.getCause() instanceof TimeoutException) {
            errMsg = errMsg + " As the maximum timeout has been reached, this could be due to an exhausted capacity of the underlying infrastructure (there is no space available to create the new build environment).";
        } else if (throwable instanceof PodFailedStartException || throwable.getCause() instanceof PodFailedStartException) {
            PodFailedStartException podFailedStartExc = throwable instanceof PodFailedStartException ? (PodFailedStartException)throwable : (PodFailedStartException)throwable.getCause();
            errMsg = podFailedStartExc != null && Arrays.asList("ErrImagePull", "ImagePullBackOff", "InvalidImageName").contains(podFailedStartExc.getPodStatus()) ? errMsg + " The builder pod failed to start because not able to download the builder image (this could be due to issues with the builder images registry, or a misconfiguration of the builder image name)." : errMsg + " The builder pod failed to start (this could be due to misconfigured or bogus scripts, or other unknown reasons).";
        }
        if (finishedRetries) {
            errMsg = errMsg + " There are no more retries left (" + (this.creationPodRetry + 1) + " attempts were made), so we are giving up for now!";
        }
        return errMsg;
    }

    private void addFuture(CancellableCompletableFuture<Void> future) {
        this.runningMonitors.add(future);
    }

    private void cancelAndClearMonitors() {
        logger.debug("Cancelling existing monitors for this build environment");
        this.runningMonitors.forEach(f -> f.cancel(false));
        this.runningMonitors.clear();
    }

    private boolean isInternalServletAvailable() {
        try {
            URL servletUrl = new URL(this.getInternalEndpointUrl());
            logger.debug("isInternalServletAvailable with url: {}", (Object)servletUrl);
            return this.connectToPingUrl(servletUrl);
        }
        catch (IOException | IllegalArgumentException e) {
            return false;
        }
    }

    private String getPublicEndpointUrl() {
        if (this.createRoute) {
            return "http://" + this.route.getSpec().getHost() + "" + this.route.getSpec().getPath() + "/" + this.environmentConfiguration.getBuildAgentBindPath();
        }
        return this.getInternalEndpointUrl();
    }

    private String getInternalEndpointUrl() {
        if (this.service == null || this.service.getSpec() == null || this.service.getSpec().getClusterIP() == null) {
            return null;
        }
        return "http://" + this.service.getSpec().getClusterIP() + "/" + this.buildAgentContextPath + "/" + this.environmentConfiguration.getBuildAgentBindPath();
    }

    private boolean isPodRunning() {
        this.pod = (Pod)((PodResource)this.client.pods().withName(this.pod.getMetadata().getName())).get();
        String podStatus = this.pod.getStatus().getPhase();
        logger.debug("Pod {} status: {}", (Object)this.pod.getMetadata().getName(), (Object)podStatus);
        if (Arrays.asList(POD_FAILED_STATUSES).contains(podStatus)) {
            this.gaugeMetric.ifPresent(g -> g.incrementMetric("openshift-environment-driver.started.pod.failed_reason." + podStatus));
            throw new PodFailedStartException("Pod failed with status: " + podStatus, podStatus);
        }
        boolean isRunning = "Running".equals(this.pod.getStatus().getPhase());
        if (isRunning) {
            logger.debug("Pod {} running.", (Object)this.pod.getMetadata().getName());
            return true;
        }
        return false;
    }

    private boolean isServiceRunning() {
        this.service = (Service)((ServiceResource)this.client.services().withName(this.service.getMetadata().getName())).get();
        return this.service.getSpec().getClusterIP() != null;
    }

    private boolean isRouteRunning() {
        try {
            if (this.connectToPingUrl(new URL(this.getPublicEndpointUrl()))) {
                this.route = (Route)((io.fabric8.kubernetes.client.dsl.Resource)this.client.routes().withName(this.route.getMetadata().getName())).get();
                logger.debug("Route {} running.", (Object)this.route.getMetadata().getName());
                return true;
            }
            return false;
        }
        catch (IOException e) {
            logger.warn("Cannot open URL {}", (Object)this.getPublicEndpointUrl(), (Object)e);
            return false;
        }
    }

    public String getId() {
        return this.pod.getMetadata().getName();
    }

    public void cancel() {
        this.cancelRequested = true;
        this.creatingPod.cancel(false);
        this.creatingService.cancel(false);
        this.creatingRoute.ifPresent(f -> f.cancel(false));
        this.cancelAndClearMonitors();
        if (this.cancelHook != null) {
            this.cancelHook.run();
        } else {
            logger.warn("Trying to cancel operation while no cancel hook is defined.");
        }
        this.destroyEnvironment();
    }

    public void destroyEnvironment() {
        this.destroyEnvironment(this.route, this.service, this.sshService, this.pod, false);
    }

    private void destroyEnvironment(Route routeLocal, Service serviceLocal, Service sshServiceLocal, Pod podLocal, boolean force) {
        if (!(this.debugData.isDebugEnabled() && !force || this.environmentConfiguration.getKeepBuildAgentInstance())) {
            if (this.createRoute) {
                this.tryOpenshiftDeleteResource(this.client.routes(), routeLocal);
            }
            this.tryOpenshiftDeleteResource(this.client.services(), serviceLocal);
            if (this.sshService != null) {
                this.tryOpenshiftDeleteResource(this.client.services(), sshServiceLocal);
            }
            this.tryOpenshiftDeleteResource(this.client.pods(), podLocal);
        }
    }

    private <T extends HasMetadata, L extends KubernetesResource, R extends io.fabric8.kubernetes.client.dsl.Resource<T>> void tryOpenshiftDeleteResource(MixedOperation<T, L, R> operation, T value) {
        try {
            operation.delete((Object[])new HasMetadata[]{value});
        }
        catch (KubernetesClientException e) {
            logger.warn("Couldn't delete the Openshift resource since it does not exist", (Throwable)e);
        }
    }

    private Integer startSshService() {
        Service sshServiceCreationModel = this.createModelNode(Configurations.getContentAsString(Resource.PNC_BUILDER_SSH_SERVICE, this.openshiftBuildAgentConfig), this.environmentVariables, Service.class);
        try {
            this.sshService = (Service)this.client.services().create((Object)sshServiceCreationModel);
            return this.sshService.getSpec().getPorts().stream().filter(m -> m.getName().equals(SSH_SERVICE_PORT_NAME)).findAny().orElseThrow(() -> new RuntimeException("No ssh service in response! Service data: " + this.sshService)).getNodePort();
        }
        catch (Throwable e) {
            logger.error("Cannot create service.", e);
            return null;
        }
    }

    private boolean connectToPingUrl(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(500);
        connection.setReadTimeout(2000);
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.connect();
        int responseCode = connection.getResponseCode();
        connection.disconnect();
        logger.debug("Got {} from {}.", (Object)responseCode, (Object)url);
        return responseCode == 200;
    }

    private String toEscapedJsonString(Object object) {
        JsonStringEncoder jsonStringEncoder = JsonStringEncoder.getInstance();
        try {
            return new String(jsonStringEncoder.quoteAsString(this.mapper.writeValueAsString(object)));
        }
        catch (JsonProcessingException e) {
            logger.error("Could not parse object: {}", object, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

