/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.builddriver.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.jboss.pnc.api.enums.ResultStatus;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
public class BuildCompleted {
    private final String buildLog;
    private final ResultStatus buildStatus;
    private final String outputChecksum;
    private final boolean debugEnabled;
    private final Throwable throwable;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().buildLog(this.buildLog).buildStatus(this.buildStatus).outputChecksum(this.outputChecksum).debugEnabled(this.debugEnabled).throwable(this.throwable);
    }

    public BuildCompleted(String buildLog, ResultStatus buildStatus, String outputChecksum, boolean debugEnabled, Throwable throwable) {
        this.buildLog = buildLog;
        this.buildStatus = buildStatus;
        this.outputChecksum = outputChecksum;
        this.debugEnabled = debugEnabled;
        this.throwable = throwable;
    }

    public String getBuildLog() {
        return this.buildLog;
    }

    public ResultStatus getBuildStatus() {
        return this.buildStatus;
    }

    public String getOutputChecksum() {
        return this.outputChecksum;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildCompleted)) {
            return false;
        }
        BuildCompleted other = (BuildCompleted)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDebugEnabled() != other.isDebugEnabled()) {
            return false;
        }
        String this$buildLog = this.getBuildLog();
        String other$buildLog = other.getBuildLog();
        if (this$buildLog == null ? other$buildLog != null : !this$buildLog.equals(other$buildLog)) {
            return false;
        }
        ResultStatus this$buildStatus = this.getBuildStatus();
        ResultStatus other$buildStatus = other.getBuildStatus();
        if (this$buildStatus == null ? other$buildStatus != null : !((Object)((Object)this$buildStatus)).equals((Object)other$buildStatus)) {
            return false;
        }
        String this$outputChecksum = this.getOutputChecksum();
        String other$outputChecksum = other.getOutputChecksum();
        if (this$outputChecksum == null ? other$outputChecksum != null : !this$outputChecksum.equals(other$outputChecksum)) {
            return false;
        }
        Throwable this$throwable = this.getThrowable();
        Throwable other$throwable = other.getThrowable();
        return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildCompleted;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDebugEnabled() ? 79 : 97);
        String $buildLog = this.getBuildLog();
        result = result * 59 + ($buildLog == null ? 43 : $buildLog.hashCode());
        ResultStatus $buildStatus = this.getBuildStatus();
        result = result * 59 + ($buildStatus == null ? 43 : ((Object)((Object)$buildStatus)).hashCode());
        String $outputChecksum = this.getOutputChecksum();
        result = result * 59 + ($outputChecksum == null ? 43 : $outputChecksum.hashCode());
        Throwable $throwable = this.getThrowable();
        result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
        return result;
    }

    public String toString() {
        return "BuildCompleted(buildLog=" + this.getBuildLog() + ", buildStatus=" + (Object)((Object)this.getBuildStatus()) + ", outputChecksum=" + this.getOutputChecksum() + ", debugEnabled=" + this.isDebugEnabled() + ", throwable=" + this.getThrowable() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private String buildLog;
        private ResultStatus buildStatus;
        private String outputChecksum;
        private boolean debugEnabled;
        private Throwable throwable;

        Builder() {
        }

        public Builder buildLog(String buildLog) {
            this.buildLog = buildLog;
            return this;
        }

        public Builder buildStatus(ResultStatus buildStatus) {
            this.buildStatus = buildStatus;
            return this;
        }

        public Builder outputChecksum(String outputChecksum) {
            this.outputChecksum = outputChecksum;
            return this;
        }

        public Builder debugEnabled(boolean debugEnabled) {
            this.debugEnabled = debugEnabled;
            return this;
        }

        public Builder throwable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        public BuildCompleted build() {
            return new BuildCompleted(this.buildLog, this.buildStatus, this.outputChecksum, this.debugEnabled, this.throwable);
        }

        public String toString() {
            return "BuildCompleted.Builder(buildLog=" + this.buildLog + ", buildStatus=" + (Object)((Object)this.buildStatus) + ", outputChecksum=" + this.outputChecksum + ", debugEnabled=" + this.debugEnabled + ", throwable=" + this.throwable + ")";
        }
    }
}

