/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.deliverablesanalyzer.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.Serializable;
import java.util.List;
import org.jboss.pnc.api.deliverablesanalyzer.dto.FinderResult;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
public class AnalysisReport
implements Serializable {
    private List<FinderResult> results;
    private boolean success;
    private Throwable errorCause;

    public AnalysisReport(List<FinderResult> results) {
        this.results = results;
        this.success = true;
    }

    public AnalysisReport(Throwable errorCause) {
        this.success = false;
        this.errorCause = errorCause;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AnalysisReport(List<FinderResult> results, boolean success, Throwable errorCause) {
        this.results = results;
        this.success = success;
        this.errorCause = errorCause;
    }

    public List<FinderResult> getResults() {
        return this.results;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Throwable getErrorCause() {
        return this.errorCause;
    }

    public void setResults(List<FinderResult> results) {
        this.results = results;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setErrorCause(Throwable errorCause) {
        this.errorCause = errorCause;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalysisReport)) {
            return false;
        }
        AnalysisReport other = (AnalysisReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        List<FinderResult> this$results = this.getResults();
        List<FinderResult> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        Throwable this$errorCause = this.getErrorCause();
        Throwable other$errorCause = other.getErrorCause();
        return !(this$errorCause == null ? other$errorCause != null : !this$errorCause.equals(other$errorCause));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnalysisReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        List<FinderResult> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        Throwable $errorCause = this.getErrorCause();
        result = result * 59 + ($errorCause == null ? 43 : $errorCause.hashCode());
        return result;
    }

    public String toString() {
        return "AnalysisReport(results=" + this.getResults() + ", success=" + this.isSuccess() + ", errorCause=" + this.getErrorCause() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private List<FinderResult> results;
        private boolean success;
        private Throwable errorCause;

        Builder() {
        }

        public Builder results(List<FinderResult> results) {
            this.results = results;
            return this;
        }

        public Builder success(boolean success) {
            this.success = success;
            return this;
        }

        public Builder errorCause(Throwable errorCause) {
            this.errorCause = errorCause;
            return this;
        }

        public AnalysisReport build() {
            return new AnalysisReport(this.results, this.success, this.errorCause);
        }

        public String toString() {
            return "AnalysisReport.Builder(results=" + this.results + ", success=" + this.success + ", errorCause=" + this.errorCause + ")";
        }
    }
}

