/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.repositorydriver.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.jboss.pnc.api.dto.Request;
import org.jboss.pnc.api.enums.BuildCategory;
import org.jboss.pnc.api.enums.BuildType;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
public class RepositoryPromoteRequest {
    private final String buildContentId;
    private final BuildType buildType;
    private final boolean tempBuild;
    private final BuildCategory buildCategory;
    private final Request callback;
    private final Request heartBeat;

    public static Builder builder() {
        return new Builder();
    }

    public RepositoryPromoteRequest(String buildContentId, BuildType buildType, boolean tempBuild, BuildCategory buildCategory, Request callback, Request heartBeat) {
        this.buildContentId = buildContentId;
        this.buildType = buildType;
        this.tempBuild = tempBuild;
        this.buildCategory = buildCategory;
        this.callback = callback;
        this.heartBeat = heartBeat;
    }

    public String getBuildContentId() {
        return this.buildContentId;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    public boolean isTempBuild() {
        return this.tempBuild;
    }

    public BuildCategory getBuildCategory() {
        return this.buildCategory;
    }

    public Request getCallback() {
        return this.callback;
    }

    public Request getHeartBeat() {
        return this.heartBeat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepositoryPromoteRequest)) {
            return false;
        }
        RepositoryPromoteRequest other = (RepositoryPromoteRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTempBuild() != other.isTempBuild()) {
            return false;
        }
        String this$buildContentId = this.getBuildContentId();
        String other$buildContentId = other.getBuildContentId();
        if (this$buildContentId == null ? other$buildContentId != null : !this$buildContentId.equals(other$buildContentId)) {
            return false;
        }
        BuildType this$buildType = this.getBuildType();
        BuildType other$buildType = other.getBuildType();
        if (this$buildType == null ? other$buildType != null : !((Object)((Object)this$buildType)).equals((Object)other$buildType)) {
            return false;
        }
        BuildCategory this$buildCategory = this.getBuildCategory();
        BuildCategory other$buildCategory = other.getBuildCategory();
        if (this$buildCategory == null ? other$buildCategory != null : !((Object)((Object)this$buildCategory)).equals((Object)other$buildCategory)) {
            return false;
        }
        Request this$callback = this.getCallback();
        Request other$callback = other.getCallback();
        if (this$callback == null ? other$callback != null : !((Object)this$callback).equals(other$callback)) {
            return false;
        }
        Request this$heartBeat = this.getHeartBeat();
        Request other$heartBeat = other.getHeartBeat();
        return !(this$heartBeat == null ? other$heartBeat != null : !((Object)this$heartBeat).equals(other$heartBeat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RepositoryPromoteRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTempBuild() ? 79 : 97);
        String $buildContentId = this.getBuildContentId();
        result = result * 59 + ($buildContentId == null ? 43 : $buildContentId.hashCode());
        BuildType $buildType = this.getBuildType();
        result = result * 59 + ($buildType == null ? 43 : ((Object)((Object)$buildType)).hashCode());
        BuildCategory $buildCategory = this.getBuildCategory();
        result = result * 59 + ($buildCategory == null ? 43 : ((Object)((Object)$buildCategory)).hashCode());
        Request $callback = this.getCallback();
        result = result * 59 + ($callback == null ? 43 : ((Object)$callback).hashCode());
        Request $heartBeat = this.getHeartBeat();
        result = result * 59 + ($heartBeat == null ? 43 : ((Object)$heartBeat).hashCode());
        return result;
    }

    public String toString() {
        return "RepositoryPromoteRequest(buildContentId=" + this.getBuildContentId() + ", buildType=" + (Object)((Object)this.getBuildType()) + ", tempBuild=" + this.isTempBuild() + ", buildCategory=" + (Object)((Object)this.getBuildCategory()) + ", callback=" + this.getCallback() + ", heartBeat=" + this.getHeartBeat() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private String buildContentId;
        private BuildType buildType;
        private boolean tempBuild;
        private BuildCategory buildCategory;
        private Request callback;
        private Request heartBeat;

        Builder() {
        }

        public Builder buildContentId(String buildContentId) {
            this.buildContentId = buildContentId;
            return this;
        }

        public Builder buildType(BuildType buildType) {
            this.buildType = buildType;
            return this;
        }

        public Builder tempBuild(boolean tempBuild) {
            this.tempBuild = tempBuild;
            return this;
        }

        public Builder buildCategory(BuildCategory buildCategory) {
            this.buildCategory = buildCategory;
            return this;
        }

        public Builder callback(Request callback) {
            this.callback = callback;
            return this;
        }

        public Builder heartBeat(Request heartBeat) {
            this.heartBeat = heartBeat;
            return this;
        }

        public RepositoryPromoteRequest build() {
            return new RepositoryPromoteRequest(this.buildContentId, this.buildType, this.tempBuild, this.buildCategory, this.callback, this.heartBeat);
        }

        public String toString() {
            return "RepositoryPromoteRequest.Builder(buildContentId=" + this.buildContentId + ", buildType=" + (Object)((Object)this.buildType) + ", tempBuild=" + this.tempBuild + ", buildCategory=" + (Object)((Object)this.buildCategory) + ", callback=" + this.callback + ", heartBeat=" + this.heartBeat + ")";
        }
    }
}

