/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.repositorydriver.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.jboss.pnc.api.enums.BuildType;

@JsonDeserialize(builder=RepositorySealRequestBuilder.class)
public class RepositorySealRequest {
    private final String buildContentId;
    private final BuildType buildType;

    public static RepositorySealRequestBuilder builder() {
        return new RepositorySealRequestBuilder();
    }

    public RepositorySealRequest(String buildContentId, BuildType buildType) {
        this.buildContentId = buildContentId;
        this.buildType = buildType;
    }

    public String getBuildContentId() {
        return this.buildContentId;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class RepositorySealRequestBuilder {
        private String buildContentId;
        private BuildType buildType;

        RepositorySealRequestBuilder() {
        }

        public RepositorySealRequestBuilder buildContentId(String buildContentId) {
            this.buildContentId = buildContentId;
            return this;
        }

        public RepositorySealRequestBuilder buildType(BuildType buildType) {
            this.buildType = buildType;
            return this;
        }

        public RepositorySealRequest build() {
            return new RepositorySealRequest(this.buildContentId, this.buildType);
        }

        public String toString() {
            return "RepositorySealRequest.RepositorySealRequestBuilder(buildContentId=" + this.buildContentId + ", buildType=" + (Object)((Object)this.buildType) + ")";
        }
    }
}

