/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.environmentdriver.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import org.jboss.pnc.api.enums.ResultStatus;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
public class EnvironmentCreateResult {
    private final URI environmentBaseUri;
    private final String workingDirectory;
    private final String sshPassword;
    private final ResultStatus status;
    private final String message;

    public static EnvironmentCreateResult cancelled() {
        return EnvironmentCreateResult.builder().status(ResultStatus.CANCELLED).build();
    }

    public static EnvironmentCreateResult failed(Throwable throwable) {
        return EnvironmentCreateResult.builder().status(ResultStatus.FAILED).message(throwable.getMessage()).build();
    }

    public static EnvironmentCreateResult systemError(Throwable throwable) {
        return EnvironmentCreateResult.builder().status(ResultStatus.SYSTEM_ERROR).message(throwable.getMessage()).build();
    }

    public static EnvironmentCreateResult success(URI environmentBaseUri, String workingDirectory, String sshPassword) {
        return EnvironmentCreateResult.builder().status(ResultStatus.SUCCESS).environmentBaseUri(environmentBaseUri).workingDirectory(workingDirectory).sshPassword(sshPassword).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public EnvironmentCreateResult(URI environmentBaseUri, String workingDirectory, String sshPassword, ResultStatus status, String message) {
        this.environmentBaseUri = environmentBaseUri;
        this.workingDirectory = workingDirectory;
        this.sshPassword = sshPassword;
        this.status = status;
        this.message = message;
    }

    public URI getEnvironmentBaseUri() {
        return this.environmentBaseUri;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getSshPassword() {
        return this.sshPassword;
    }

    public ResultStatus getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnvironmentCreateResult)) {
            return false;
        }
        EnvironmentCreateResult other = (EnvironmentCreateResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$environmentBaseUri = this.getEnvironmentBaseUri();
        URI other$environmentBaseUri = other.getEnvironmentBaseUri();
        if (this$environmentBaseUri == null ? other$environmentBaseUri != null : !((Object)this$environmentBaseUri).equals(other$environmentBaseUri)) {
            return false;
        }
        String this$workingDirectory = this.getWorkingDirectory();
        String other$workingDirectory = other.getWorkingDirectory();
        if (this$workingDirectory == null ? other$workingDirectory != null : !this$workingDirectory.equals(other$workingDirectory)) {
            return false;
        }
        String this$sshPassword = this.getSshPassword();
        String other$sshPassword = other.getSshPassword();
        if (this$sshPassword == null ? other$sshPassword != null : !this$sshPassword.equals(other$sshPassword)) {
            return false;
        }
        ResultStatus this$status = this.getStatus();
        ResultStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnvironmentCreateResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $environmentBaseUri = this.getEnvironmentBaseUri();
        result = result * 59 + ($environmentBaseUri == null ? 43 : ((Object)$environmentBaseUri).hashCode());
        String $workingDirectory = this.getWorkingDirectory();
        result = result * 59 + ($workingDirectory == null ? 43 : $workingDirectory.hashCode());
        String $sshPassword = this.getSshPassword();
        result = result * 59 + ($sshPassword == null ? 43 : $sshPassword.hashCode());
        ResultStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "EnvironmentCreateResult(environmentBaseUri=" + this.getEnvironmentBaseUri() + ", workingDirectory=" + this.getWorkingDirectory() + ", sshPassword=" + this.getSshPassword() + ", status=" + (Object)((Object)this.getStatus()) + ", message=" + this.getMessage() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private URI environmentBaseUri;
        private String workingDirectory;
        private String sshPassword;
        private ResultStatus status;
        private String message;

        Builder() {
        }

        public Builder environmentBaseUri(URI environmentBaseUri) {
            this.environmentBaseUri = environmentBaseUri;
            return this;
        }

        public Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder sshPassword(String sshPassword) {
            this.sshPassword = sshPassword;
            return this;
        }

        public Builder status(ResultStatus status) {
            this.status = status;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public EnvironmentCreateResult build() {
            return new EnvironmentCreateResult(this.environmentBaseUri, this.workingDirectory, this.sshPassword, this.status, this.message);
        }

        public String toString() {
            return "EnvironmentCreateResult.Builder(environmentBaseUri=" + this.environmentBaseUri + ", workingDirectory=" + this.workingDirectory + ", sshPassword=" + this.sshPassword + ", status=" + (Object)((Object)this.status) + ", message=" + this.message + ")";
        }
    }
}

