/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.bifrost.dto;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.text.MessageFormat;
import java.util.Map;
import org.jboss.pnc.api.bifrost.enums.Format;

public class Line {
    private String id;
    private String timestamp;
    private String sequence;
    private String loggerName;
    private String message;
    private String stackTrace;
    private boolean last;
    private Map<String, String> mdc;
    private String subscriptionTopic;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Line fromString(String json) {
        Jsonb jsonb = JsonbBuilder.create();
        return (Line)jsonb.fromJson(json, Line.class);
    }

    public static Builder newBuilder(Line copy) {
        Builder builder = new Builder();
        builder.id = copy.getId();
        builder.timestamp = copy.getTimestamp();
        builder.sequence = copy.getSequence();
        builder.loggerName = copy.getLoggerName();
        builder.message = copy.getMessage();
        builder.stackTrace = copy.getStackTrace();
        builder.last = copy.isLast();
        builder.mdc = copy.getMdc();
        return builder;
    }

    public String asString() {
        return this.asString(Format.DEFAULT);
    }

    public String asString(Format format) {
        switch (format) {
            case TIMESTAMP: {
                return this.getTimestamp() + " " + this.getMessage();
            }
            case PLAIN: {
                return this.getMessage();
            }
            case LEVEL: {
                return this.getLevel() + this.getMessage();
            }
        }
        return this.getTimestamp() + " " + this.getLoggerName() + " " + this.getMessage();
    }

    private String getLevel() {
        if (this.mdc.containsKey("level")) {
            return MessageFormat.format("[{0}] ", this.mdc.get("level"));
        }
        return null;
    }

    public Builder cloneBuilder() {
        return Line.newBuilder(this);
    }

    public String getId() {
        return this.id;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public boolean isLast() {
        return this.last;
    }

    public Map<String, String> getMdc() {
        return this.mdc;
    }

    public String getSubscriptionTopic() {
        return this.subscriptionTopic;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public void setMdc(Map<String, String> mdc) {
        this.mdc = mdc;
    }

    public void setSubscriptionTopic(String subscriptionTopic) {
        this.subscriptionTopic = subscriptionTopic;
    }

    public String toString() {
        return "Line(id=" + this.getId() + ", timestamp=" + this.getTimestamp() + ", sequence=" + this.getSequence() + ", loggerName=" + this.getLoggerName() + ", message=" + this.getMessage() + ", stackTrace=" + this.getStackTrace() + ", last=" + this.isLast() + ", mdc=" + this.getMdc() + ", subscriptionTopic=" + this.getSubscriptionTopic() + ")";
    }

    public static final class Builder {
        private String id;
        private String timestamp;
        private String sequence;
        private String loggerName;
        private String message;
        private String stackTrace;
        private boolean last;
        private Map<String, String> mdc;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder sequence(String sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder logger(String logger) {
            this.loggerName = logger;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder stackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public Builder last(boolean last) {
            this.last = last;
            return this;
        }

        public Builder mdc(Map<String, String> mdc) {
            this.mdc = mdc;
            return this;
        }

        public Line build() {
            Line line = new Line();
            line.id = this.id;
            line.timestamp = this.timestamp;
            line.sequence = this.sequence;
            line.loggerName = this.loggerName;
            line.message = this.message;
            line.stackTrace = this.stackTrace;
            line.last = this.last;
            line.mdc = this.mdc;
            return line;
        }
    }
}

