/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.causeway.dto.push;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;
import org.jboss.pnc.api.causeway.dto.push.Build;
import org.jboss.pnc.api.causeway.dto.push.BuildRoot;
import org.jboss.pnc.api.causeway.dto.push.BuiltArtifact;
import org.jboss.pnc.api.causeway.dto.push.Dependency;
import org.jboss.pnc.api.causeway.dto.push.Logfile;

@JsonTypeName(value="npm")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=NpmBuildBuilder.class)
public class NpmBuild
extends Build {
    @NonNull
    private final String name;
    private final String version;

    private NpmBuild(String name, String version, String buildName, String buildVersion, String externalBuildSystem, String externalBuildID, String externalBuildURL, Date startTime, Date endTime, String scmURL, String scmRevision, String scmTag, BuildRoot buildRoot, Set<Logfile> logs, String sourcesURL, Set<Dependency> dependencies, Set<BuiltArtifact> builtArtifacts, String tagPrefix) {
        super(buildName, buildVersion, externalBuildSystem, externalBuildID, externalBuildURL, startTime, endTime, scmURL, scmRevision, scmTag, buildRoot, logs, sourcesURL, dependencies, builtArtifacts, tagPrefix);
        this.name = Objects.requireNonNull(name);
        this.version = version;
    }

    public static NpmBuildBuilder builder() {
        return new NpmBuildBuilder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public String toString() {
        return "NpmBuild(name=" + this.getName() + ", version=" + this.getVersion() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NpmBuild)) {
            return false;
        }
        NpmBuild other = (NpmBuild)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NpmBuild;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @JsonTypeName(value="npm")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class NpmBuildBuilder {
        private String name;
        private String version;
        private String buildName;
        private String buildVersion;
        private String externalBuildSystem;
        private String externalBuildID;
        private String externalBuildURL;
        private Date startTime;
        private Date endTime;
        private String scmURL;
        private String scmRevision;
        private String scmTag;
        private BuildRoot buildRoot;
        private Set<Logfile> logs;
        private String sourcesURL;
        private Set<Dependency> dependencies;
        private Set<BuiltArtifact> builtArtifacts;
        private String tagPrefix;

        NpmBuildBuilder() {
        }

        public NpmBuildBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NpmBuildBuilder version(String version) {
            this.version = version;
            return this;
        }

        public NpmBuildBuilder buildName(String buildName) {
            this.buildName = buildName;
            return this;
        }

        public NpmBuildBuilder buildVersion(String buildVersion) {
            this.buildVersion = buildVersion;
            return this;
        }

        public NpmBuildBuilder externalBuildSystem(String externalBuildSystem) {
            this.externalBuildSystem = externalBuildSystem;
            return this;
        }

        public NpmBuildBuilder externalBuildID(String externalBuildID) {
            this.externalBuildID = externalBuildID;
            return this;
        }

        public NpmBuildBuilder externalBuildURL(String externalBuildURL) {
            this.externalBuildURL = externalBuildURL;
            return this;
        }

        public NpmBuildBuilder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        public NpmBuildBuilder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public NpmBuildBuilder scmURL(String scmURL) {
            this.scmURL = scmURL;
            return this;
        }

        public NpmBuildBuilder scmRevision(String scmRevision) {
            this.scmRevision = scmRevision;
            return this;
        }

        public NpmBuildBuilder scmTag(String scmTag) {
            this.scmTag = scmTag;
            return this;
        }

        public NpmBuildBuilder buildRoot(BuildRoot buildRoot) {
            this.buildRoot = buildRoot;
            return this;
        }

        public NpmBuildBuilder logs(Set<Logfile> logs) {
            this.logs = logs;
            return this;
        }

        public NpmBuildBuilder sourcesURL(String sourcesURL) {
            this.sourcesURL = sourcesURL;
            return this;
        }

        public NpmBuildBuilder dependencies(Set<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public NpmBuildBuilder builtArtifacts(Set<BuiltArtifact> builtArtifacts) {
            this.builtArtifacts = builtArtifacts;
            return this;
        }

        public NpmBuildBuilder tagPrefix(String tagPrefix) {
            this.tagPrefix = tagPrefix;
            return this;
        }

        public NpmBuild build() {
            return new NpmBuild(this.name, this.version, this.buildName, this.buildVersion, this.externalBuildSystem, this.externalBuildID, this.externalBuildURL, this.startTime, this.endTime, this.scmURL, this.scmRevision, this.scmTag, this.buildRoot, this.logs, this.sourcesURL, this.dependencies, this.builtArtifacts, this.tagPrefix);
        }

        public String toString() {
            return "NpmBuild.NpmBuildBuilder(name=" + this.name + ", version=" + this.version + ", buildName=" + this.buildName + ", buildVersion=" + this.buildVersion + ", externalBuildSystem=" + this.externalBuildSystem + ", externalBuildID=" + this.externalBuildID + ", externalBuildURL=" + this.externalBuildURL + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", scmURL=" + this.scmURL + ", scmRevision=" + this.scmRevision + ", scmTag=" + this.scmTag + ", buildRoot=" + this.buildRoot + ", logs=" + this.logs + ", sourcesURL=" + this.sourcesURL + ", dependencies=" + this.dependencies + ", builtArtifacts=" + this.builtArtifacts + ", tagPrefix=" + this.tagPrefix + ")";
        }
    }
}

