/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.deliverablesanalyzer.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import java.util.Objects;
import java.util.Set;
import org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact;
import org.jboss.pnc.api.deliverablesanalyzer.dto.BuildSystemType;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
public class Build {
    private final BuildSystemType buildSystemType;
    @Positive
    private final Long brewId;
    private final String brewNVR;
    private final String pncId;
    @Valid
    @JsonIgnoreProperties(value={"build"})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Set<Artifact> artifacts;
    private final boolean isImport;

    public static Build fromPNC(String id, Set<Artifact> artifacts) {
        return Build.fromPNC(id, artifacts, false);
    }

    public static Build fromKoji(long id, String nvr, Set<Artifact> artifacts) {
        return Build.fromKoji(id, nvr, artifacts, false);
    }

    public static Build fromPNC(String id, Set<Artifact> artifacts, boolean isImport) {
        return new Build(BuildSystemType.PNC, null, null, Objects.requireNonNull(id), artifacts, isImport);
    }

    public static Build fromKoji(long id, String nvr, Set<Artifact> artifacts, boolean isImport) {
        return new Build(BuildSystemType.BREW, id, Objects.requireNonNull(nvr), null, artifacts, isImport);
    }

    public static Builder builder() {
        return new Builder();
    }

    public BuildSystemType getBuildSystemType() {
        return this.buildSystemType;
    }

    public Long getBrewId() {
        return this.brewId;
    }

    public String getBrewNVR() {
        return this.brewNVR;
    }

    public String getPncId() {
        return this.pncId;
    }

    public Set<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public boolean isImport() {
        return this.isImport;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Build)) {
            return false;
        }
        Build other = (Build)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isImport() != other.isImport()) {
            return false;
        }
        Long this$brewId = this.getBrewId();
        Long other$brewId = other.getBrewId();
        if (this$brewId == null ? other$brewId != null : !((Object)this$brewId).equals(other$brewId)) {
            return false;
        }
        BuildSystemType this$buildSystemType = this.getBuildSystemType();
        BuildSystemType other$buildSystemType = other.getBuildSystemType();
        if (this$buildSystemType == null ? other$buildSystemType != null : !((Object)((Object)this$buildSystemType)).equals((Object)other$buildSystemType)) {
            return false;
        }
        String this$brewNVR = this.getBrewNVR();
        String other$brewNVR = other.getBrewNVR();
        if (this$brewNVR == null ? other$brewNVR != null : !this$brewNVR.equals(other$brewNVR)) {
            return false;
        }
        String this$pncId = this.getPncId();
        String other$pncId = other.getPncId();
        if (this$pncId == null ? other$pncId != null : !this$pncId.equals(other$pncId)) {
            return false;
        }
        Set<Artifact> this$artifacts = this.getArtifacts();
        Set<Artifact> other$artifacts = other.getArtifacts();
        return !(this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Build;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isImport() ? 79 : 97);
        Long $brewId = this.getBrewId();
        result = result * 59 + ($brewId == null ? 43 : ((Object)$brewId).hashCode());
        BuildSystemType $buildSystemType = this.getBuildSystemType();
        result = result * 59 + ($buildSystemType == null ? 43 : ((Object)((Object)$buildSystemType)).hashCode());
        String $brewNVR = this.getBrewNVR();
        result = result * 59 + ($brewNVR == null ? 43 : $brewNVR.hashCode());
        String $pncId = this.getPncId();
        result = result * 59 + ($pncId == null ? 43 : $pncId.hashCode());
        Set<Artifact> $artifacts = this.getArtifacts();
        result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
        return result;
    }

    public Build(BuildSystemType buildSystemType, Long brewId, String brewNVR, String pncId, Set<Artifact> artifacts, boolean isImport) {
        this.buildSystemType = buildSystemType;
        this.brewId = brewId;
        this.brewNVR = brewNVR;
        this.pncId = pncId;
        this.artifacts = artifacts;
        this.isImport = isImport;
    }

    public String toString() {
        return "Build(buildSystemType=" + (Object)((Object)this.getBuildSystemType()) + ", brewId=" + this.getBrewId() + ", brewNVR=" + this.getBrewNVR() + ", pncId=" + this.getPncId() + ", artifacts=" + this.getArtifacts() + ", isImport=" + this.isImport() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private BuildSystemType buildSystemType;
        private Long brewId;
        private String brewNVR;
        private String pncId;
        private Set<Artifact> artifacts;
        private boolean isImport;

        Builder() {
        }

        public Builder buildSystemType(BuildSystemType buildSystemType) {
            this.buildSystemType = buildSystemType;
            return this;
        }

        public Builder brewId(Long brewId) {
            this.brewId = brewId;
            return this;
        }

        public Builder brewNVR(String brewNVR) {
            this.brewNVR = brewNVR;
            return this;
        }

        public Builder pncId(String pncId) {
            this.pncId = pncId;
            return this;
        }

        @JsonIgnoreProperties(value={"build"})
        public Builder artifacts(Set<Artifact> artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public Builder isImport(boolean isImport) {
            this.isImport = isImport;
            return this;
        }

        public Build build() {
            return new Build(this.buildSystemType, this.brewId, this.brewNVR, this.pncId, this.artifacts, this.isImport);
        }

        public String toString() {
            return "Build.Builder(buildSystemType=" + (Object)((Object)this.buildSystemType) + ", brewId=" + this.brewId + ", brewNVR=" + this.brewNVR + ", pncId=" + this.pncId + ", artifacts=" + this.artifacts + ", isImport=" + this.isImport + ")";
        }
    }
}

