/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.trustbox;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;

@JsonDeserialize(builder=TrustboxTokenRequestBuilder.class)
public class TrustboxTokenRequest {
    private String authServerUrl;
    private String clientId;
    private String clientSecret;

    TrustboxTokenRequest(String authServerUrl, String clientId, String clientSecret) {
        this.authServerUrl = authServerUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public static TrustboxTokenRequestBuilder builder() {
        return new TrustboxTokenRequestBuilder();
    }

    public String getAuthServerUrl() {
        return this.authServerUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = authServerUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class TrustboxTokenRequestBuilder {
        private String authServerUrl;
        private String clientId;
        private String clientSecret;

        TrustboxTokenRequestBuilder() {
        }

        public TrustboxTokenRequestBuilder authServerUrl(String authServerUrl) {
            this.authServerUrl = authServerUrl;
            return this;
        }

        public TrustboxTokenRequestBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public TrustboxTokenRequestBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public TrustboxTokenRequest build() {
            return new TrustboxTokenRequest(this.authServerUrl, this.clientId, this.clientSecret);
        }

        public String toString() {
            return "TrustboxTokenRequest.TrustboxTokenRequestBuilder(authServerUrl=" + this.authServerUrl + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ")";
        }
    }
}

