/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.deliverablesanalyzer.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import lombok.NonNull;
import org.jboss.pnc.api.deliverablesanalyzer.dto.FinderResult;
import org.jboss.pnc.api.dto.Request;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
public class AnalysisResult {
    @NonNull
    private final String operationId;
    @NonNull
    private final List<FinderResult> results;
    private final boolean scratch;
    @NonNull
    private final Request callback;

    AnalysisResult(@NonNull String operationId, @NonNull List<FinderResult> results, boolean scratch, @NonNull Request callback) {
        if (operationId == null) {
            throw new NullPointerException("operationId is marked non-null but is null");
        }
        if (results == null) {
            throw new NullPointerException("results is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        this.operationId = operationId;
        this.results = results;
        this.scratch = scratch;
        this.callback = callback;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public String getOperationId() {
        return this.operationId;
    }

    @NonNull
    public List<FinderResult> getResults() {
        return this.results;
    }

    public boolean isScratch() {
        return this.scratch;
    }

    @NonNull
    public Request getCallback() {
        return this.callback;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalysisResult)) {
            return false;
        }
        AnalysisResult other = (AnalysisResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isScratch() != other.isScratch()) {
            return false;
        }
        String this$operationId = this.getOperationId();
        String other$operationId = other.getOperationId();
        if (this$operationId == null ? other$operationId != null : !this$operationId.equals(other$operationId)) {
            return false;
        }
        List<FinderResult> this$results = this.getResults();
        List<FinderResult> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        Request this$callback = this.getCallback();
        Request other$callback = other.getCallback();
        return !(this$callback == null ? other$callback != null : !((Object)this$callback).equals(other$callback));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnalysisResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isScratch() ? 79 : 97);
        String $operationId = this.getOperationId();
        result = result * 59 + ($operationId == null ? 43 : $operationId.hashCode());
        List<FinderResult> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        Request $callback = this.getCallback();
        result = result * 59 + ($callback == null ? 43 : ((Object)$callback).hashCode());
        return result;
    }

    public String toString() {
        return "AnalysisResult(operationId=" + this.getOperationId() + ", results=" + this.getResults() + ", scratch=" + this.isScratch() + ", callback=" + this.getCallback() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private String operationId;
        private List<FinderResult> results;
        private boolean scratch;
        private Request callback;

        Builder() {
        }

        public Builder operationId(@NonNull String operationId) {
            if (operationId == null) {
                throw new NullPointerException("operationId is marked non-null but is null");
            }
            this.operationId = operationId;
            return this;
        }

        public Builder results(@NonNull List<FinderResult> results) {
            if (results == null) {
                throw new NullPointerException("results is marked non-null but is null");
            }
            this.results = results;
            return this;
        }

        public Builder scratch(boolean scratch) {
            this.scratch = scratch;
            return this;
        }

        public Builder callback(@NonNull Request callback) {
            if (callback == null) {
                throw new NullPointerException("callback is marked non-null but is null");
            }
            this.callback = callback;
            return this;
        }

        public AnalysisResult build() {
            return new AnalysisResult(this.operationId, this.results, this.scratch, this.callback);
        }

        public String toString() {
            return "AnalysisResult.Builder(operationId=" + this.operationId + ", results=" + this.results + ", scratch=" + this.scratch + ", callback=" + this.callback + ")";
        }
    }
}

