/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.deliverablesanalyzer.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Collection;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import org.jboss.pnc.api.deliverablesanalyzer.dto.ArtifactType;
import org.jboss.pnc.api.deliverablesanalyzer.dto.BuildSystemType;
import org.jboss.pnc.api.deliverablesanalyzer.dto.LicenseInfo;
import org.jboss.pnc.api.deliverablesanalyzer.dto.MavenArtifact;
import org.jboss.pnc.api.deliverablesanalyzer.dto.NPMArtifact;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="artifactType", defaultImpl=Artifact.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=MavenArtifact.class, name="MAVEN"), @JsonSubTypes.Type(value=NPMArtifact.class, name="NPM")})
@JsonDeserialize(builder=ArtifactBuilderImpl.class)
public class Artifact {
    private final BuildSystemType buildSystemType;
    @Positive
    private final Long brewId;
    private final String pncId;
    private final ArtifactType artifactType;
    @NotBlank
    private final String filename;
    private final long size;
    @Pattern(regexp="^[a-f0-9]{32}$")
    private final @Pattern(regexp="^[a-f0-9]{32}$") String md5;
    @Pattern(regexp="^[a-f0-9]{40}$")
    private final @Pattern(regexp="^[a-f0-9]{40}$") String sha1;
    @Pattern(regexp="^[a-f0-9]{64}$")
    private final @Pattern(regexp="^[a-f0-9]{64}$") String sha256;
    private final boolean builtFromSource;
    private final Collection<String> archiveFilenames;
    private final Collection<String> archiveUnmatchedFilenames;
    private final Collection<LicenseInfo> licenses;

    protected Artifact(ArtifactBuilder<?, ?> b) {
        this.buildSystemType = ((ArtifactBuilder)b).buildSystemType;
        this.brewId = ((ArtifactBuilder)b).brewId;
        this.pncId = ((ArtifactBuilder)b).pncId;
        this.artifactType = ((ArtifactBuilder)b).artifactType;
        this.filename = ((ArtifactBuilder)b).filename;
        this.size = ((ArtifactBuilder)b).size;
        this.md5 = ((ArtifactBuilder)b).md5;
        this.sha1 = ((ArtifactBuilder)b).sha1;
        this.sha256 = ((ArtifactBuilder)b).sha256;
        this.builtFromSource = ((ArtifactBuilder)b).builtFromSource;
        this.archiveFilenames = ((ArtifactBuilder)b).archiveFilenames;
        this.archiveUnmatchedFilenames = ((ArtifactBuilder)b).archiveUnmatchedFilenames;
        this.licenses = ((ArtifactBuilder)b).licenses;
    }

    public static ArtifactBuilder<?, ?> builder() {
        return new ArtifactBuilderImpl();
    }

    public BuildSystemType getBuildSystemType() {
        return this.buildSystemType;
    }

    public Long getBrewId() {
        return this.brewId;
    }

    public String getPncId() {
        return this.pncId;
    }

    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getSize() {
        return this.size;
    }

    public String getMd5() {
        return this.md5;
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getSha256() {
        return this.sha256;
    }

    public boolean isBuiltFromSource() {
        return this.builtFromSource;
    }

    public Collection<String> getArchiveFilenames() {
        return this.archiveFilenames;
    }

    public Collection<String> getArchiveUnmatchedFilenames() {
        return this.archiveUnmatchedFilenames;
    }

    public Collection<LicenseInfo> getLicenses() {
        return this.licenses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.isBuiltFromSource() != other.isBuiltFromSource()) {
            return false;
        }
        Long this$brewId = this.getBrewId();
        Long other$brewId = other.getBrewId();
        if (this$brewId == null ? other$brewId != null : !((Object)this$brewId).equals(other$brewId)) {
            return false;
        }
        BuildSystemType this$buildSystemType = this.getBuildSystemType();
        BuildSystemType other$buildSystemType = other.getBuildSystemType();
        if (this$buildSystemType == null ? other$buildSystemType != null : !((Object)((Object)this$buildSystemType)).equals((Object)other$buildSystemType)) {
            return false;
        }
        String this$pncId = this.getPncId();
        String other$pncId = other.getPncId();
        if (this$pncId == null ? other$pncId != null : !this$pncId.equals(other$pncId)) {
            return false;
        }
        ArtifactType this$artifactType = this.getArtifactType();
        ArtifactType other$artifactType = other.getArtifactType();
        if (this$artifactType == null ? other$artifactType != null : !((Object)((Object)this$artifactType)).equals((Object)other$artifactType)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$md5 = this.getMd5();
        String other$md5 = other.getMd5();
        if (this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5)) {
            return false;
        }
        String this$sha1 = this.getSha1();
        String other$sha1 = other.getSha1();
        if (this$sha1 == null ? other$sha1 != null : !this$sha1.equals(other$sha1)) {
            return false;
        }
        String this$sha256 = this.getSha256();
        String other$sha256 = other.getSha256();
        if (this$sha256 == null ? other$sha256 != null : !this$sha256.equals(other$sha256)) {
            return false;
        }
        Collection<String> this$archiveFilenames = this.getArchiveFilenames();
        Collection<String> other$archiveFilenames = other.getArchiveFilenames();
        if (this$archiveFilenames == null ? other$archiveFilenames != null : !((Object)this$archiveFilenames).equals(other$archiveFilenames)) {
            return false;
        }
        Collection<String> this$archiveUnmatchedFilenames = this.getArchiveUnmatchedFilenames();
        Collection<String> other$archiveUnmatchedFilenames = other.getArchiveUnmatchedFilenames();
        if (this$archiveUnmatchedFilenames == null ? other$archiveUnmatchedFilenames != null : !((Object)this$archiveUnmatchedFilenames).equals(other$archiveUnmatchedFilenames)) {
            return false;
        }
        Collection<LicenseInfo> this$licenses = this.getLicenses();
        Collection<LicenseInfo> other$licenses = other.getLicenses();
        return !(this$licenses == null ? other$licenses != null : !((Object)this$licenses).equals(other$licenses));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Artifact;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        result = result * 59 + (this.isBuiltFromSource() ? 79 : 97);
        Long $brewId = this.getBrewId();
        result = result * 59 + ($brewId == null ? 43 : ((Object)$brewId).hashCode());
        BuildSystemType $buildSystemType = this.getBuildSystemType();
        result = result * 59 + ($buildSystemType == null ? 43 : ((Object)((Object)$buildSystemType)).hashCode());
        String $pncId = this.getPncId();
        result = result * 59 + ($pncId == null ? 43 : $pncId.hashCode());
        ArtifactType $artifactType = this.getArtifactType();
        result = result * 59 + ($artifactType == null ? 43 : ((Object)((Object)$artifactType)).hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $md5 = this.getMd5();
        result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
        String $sha1 = this.getSha1();
        result = result * 59 + ($sha1 == null ? 43 : $sha1.hashCode());
        String $sha256 = this.getSha256();
        result = result * 59 + ($sha256 == null ? 43 : $sha256.hashCode());
        Collection<String> $archiveFilenames = this.getArchiveFilenames();
        result = result * 59 + ($archiveFilenames == null ? 43 : ((Object)$archiveFilenames).hashCode());
        Collection<String> $archiveUnmatchedFilenames = this.getArchiveUnmatchedFilenames();
        result = result * 59 + ($archiveUnmatchedFilenames == null ? 43 : ((Object)$archiveUnmatchedFilenames).hashCode());
        Collection<LicenseInfo> $licenses = this.getLicenses();
        result = result * 59 + ($licenses == null ? 43 : ((Object)$licenses).hashCode());
        return result;
    }

    public String toString() {
        return "Artifact(buildSystemType=" + (Object)((Object)this.getBuildSystemType()) + ", brewId=" + this.getBrewId() + ", pncId=" + this.getPncId() + ", artifactType=" + (Object)((Object)this.getArtifactType()) + ", filename=" + this.getFilename() + ", size=" + this.getSize() + ", md5=" + this.getMd5() + ", sha1=" + this.getSha1() + ", sha256=" + this.getSha256() + ", builtFromSource=" + this.isBuiltFromSource() + ", archiveFilenames=" + this.getArchiveFilenames() + ", archiveUnmatchedFilenames=" + this.getArchiveUnmatchedFilenames() + ", licenses=" + this.getLicenses() + ")";
    }

    public static abstract class ArtifactBuilder<C extends Artifact, B extends ArtifactBuilder<C, B>> {
        private BuildSystemType buildSystemType;
        private Long brewId;
        private String pncId;
        private ArtifactType artifactType;
        private String filename;
        private long size;
        private String md5;
        private String sha1;
        private String sha256;
        private boolean builtFromSource;
        private Collection<String> archiveFilenames;
        private Collection<String> archiveUnmatchedFilenames;
        private Collection<LicenseInfo> licenses;

        public B buildSystemType(BuildSystemType buildSystemType) {
            this.buildSystemType = buildSystemType;
            return this.self();
        }

        public B brewId(Long brewId) {
            this.brewId = brewId;
            return this.self();
        }

        public B pncId(String pncId) {
            this.pncId = pncId;
            return this.self();
        }

        public B artifactType(ArtifactType artifactType) {
            this.artifactType = artifactType;
            return this.self();
        }

        public B filename(String filename) {
            this.filename = filename;
            return this.self();
        }

        public B size(long size) {
            this.size = size;
            return this.self();
        }

        public B md5(String md5) {
            this.md5 = md5;
            return this.self();
        }

        public B sha1(String sha1) {
            this.sha1 = sha1;
            return this.self();
        }

        public B sha256(String sha256) {
            this.sha256 = sha256;
            return this.self();
        }

        public B builtFromSource(boolean builtFromSource) {
            this.builtFromSource = builtFromSource;
            return this.self();
        }

        public B archiveFilenames(Collection<String> archiveFilenames) {
            this.archiveFilenames = archiveFilenames;
            return this.self();
        }

        public B archiveUnmatchedFilenames(Collection<String> archiveUnmatchedFilenames) {
            this.archiveUnmatchedFilenames = archiveUnmatchedFilenames;
            return this.self();
        }

        public B licenses(Collection<LicenseInfo> licenses) {
            this.licenses = licenses;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "Artifact.ArtifactBuilder(buildSystemType=" + (Object)((Object)this.buildSystemType) + ", brewId=" + this.brewId + ", pncId=" + this.pncId + ", artifactType=" + (Object)((Object)this.artifactType) + ", filename=" + this.filename + ", size=" + this.size + ", md5=" + this.md5 + ", sha1=" + this.sha1 + ", sha256=" + this.sha256 + ", builtFromSource=" + this.builtFromSource + ", archiveFilenames=" + this.archiveFilenames + ", archiveUnmatchedFilenames=" + this.archiveUnmatchedFilenames + ", licenses=" + this.licenses + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="artifactType", defaultImpl=Artifact.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=MavenArtifact.class, name="MAVEN"), @JsonSubTypes.Type(value=NPMArtifact.class, name="NPM")})
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class ArtifactBuilderImpl
    extends ArtifactBuilder<Artifact, ArtifactBuilderImpl> {
        private ArtifactBuilderImpl() {
        }

        @Override
        protected ArtifactBuilderImpl self() {
            return this;
        }

        @Override
        public Artifact build() {
            return new Artifact(this);
        }
    }
}

