/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.jboss.pnc.api.dto.validation.ValidURI;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
public class Request {
    @NotNull
    private final Method method;
    @ValidURI
    private final URI uri;
    private final List<@Valid Header> headers;
    private final Object attachment;

    public Request(Method method, URI uri) {
        this(method, uri, new ArrayList<Header>(), null);
    }

    public Request(Method method, URI uri, List<Header> headers) {
        this(method, uri, headers, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Method getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    public List<@Valid Header> getHeaders() {
        return this.headers;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request other = (Request)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        List<Header> this$headers = this.getHeaders();
        List<Header> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Object this$attachment = this.getAttachment();
        Object other$attachment = other.getAttachment();
        return !(this$attachment == null ? other$attachment != null : !this$attachment.equals(other$attachment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Request;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        List<Header> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Object $attachment = this.getAttachment();
        result = result * 59 + ($attachment == null ? 43 : $attachment.hashCode());
        return result;
    }

    public String toString() {
        return "Request(method=" + (Object)((Object)this.getMethod()) + ", uri=" + this.getUri() + ", headers=" + this.getHeaders() + ", attachment=" + this.getAttachment() + ")";
    }

    public Request(Method method, URI uri, List<@Valid Header> headers, Object attachment) {
        this.method = method;
        this.uri = uri;
        this.headers = headers;
        this.attachment = attachment;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        PATCH,
        OPTIONS;

    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private Method method;
        private URI uri;
        private Object attachment;
        private List<Header> headers = new ArrayList<Header>();

        public Builder header(Header header) {
            this.headers.add(header);
            return this;
        }

        public Builder header(String name, String value) {
            return this.header(new Header(name, value));
        }

        public Builder authTokenHeader(String token) {
            return this.header("Authorization", "Bearer " + token);
        }

        Builder() {
        }

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder headers(List<Header> headers) {
            this.headers = headers;
            return this;
        }

        public Builder attachment(Object attachment) {
            this.attachment = attachment;
            return this;
        }

        public Request build() {
            return new Request(this.method, this.uri, this.headers, this.attachment);
        }

        public String toString() {
            return "Request.Builder(method=" + (Object)((Object)this.method) + ", uri=" + this.uri + ", headers=" + this.headers + ", attachment=" + this.attachment + ")";
        }
    }

    public static final class Header {
        @NotBlank(message="Header name cannot be empty")
        private final @NotBlank(message="Header name cannot be empty") String name;
        @NotNull(message="Header value cannot be missing")
        private final @NotNull(message="Header value cannot be missing") String value;

        public String toString() {
            if ("Authorization".equals(this.getName())) {
                return this.getName() + ":***";
            }
            return this.getName() + ":" + this.getValue();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Header)) {
                return false;
            }
            Header other = (Header)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        private Header() {
            this.name = null;
            this.value = null;
        }

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

