/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.enums;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Optional;
import org.jboss.pnc.api.dto.validation.ValidationResult;

public enum Qualifier {
    PRODUCT_ID(1),
    PRODUCT(1, PRODUCT_ID){

        @Override
        public ValidationResult validate(String ... values) {
            ValidationResult result = super.validate(values);
            if (!result.isValid()) {
                return result;
            }
            if (!values[0].matches("[a-zA-Z0-9-]+")) {
                return ValidationResult.withError(MessageFormat.format("Product abbreviation does not match {0}.", "[a-zA-Z0-9-]+"));
            }
            return ValidationResult.valid();
        }
    }
    ,
    VERSION_ID(1),
    VERSION(2, VERSION_ID){

        @Override
        public ValidationResult validate(String ... values) {
            ValidationResult result = super.validate(values);
            if (!result.isValid()) {
                return result;
            }
            result = PRODUCT.validate(values[0]);
            if (!result.isValid()) {
                return result;
            }
            if (!values[1].matches("^[0-9]+\\.[0-9]+$")) {
                return ValidationResult.withError(MessageFormat.format("Product Version part does not match {0}.", "^[0-9]+\\.[0-9]+$"));
            }
            return ValidationResult.valid();
        }
    }
    ,
    MILESTONE_ID(1),
    MILESTONE(2, MILESTONE_ID){

        @Override
        public ValidationResult validate(String ... values) {
            ValidationResult result = super.validate(values);
            if (!result.isValid()) {
                return result;
            }
            result = PRODUCT.validate(values[0]);
            if (!result.isValid()) {
                return result;
            }
            if (!values[1].matches("^[0-9]+\\.[0-9]+(\\.\\w[\\w-]*)+$")) {
                return ValidationResult.withError(MessageFormat.format("Product Milestone part does not match {0}.", "^[0-9]+\\.[0-9]+(\\.\\w[\\w-]*)+$"));
            }
            return ValidationResult.valid();
        }
    }
    ,
    GROUP_BUILD(1),
    BUILD(1),
    BUILD_CONFIG_ID(1),
    BUILD_CONFIG(1, BUILD_CONFIG_ID),
    GROUP_CONFIG_ID(1),
    GROUP_CONFIG(1, GROUP_CONFIG_ID),
    DEPENDENCY(1),
    QUALITY(1);

    public final int parts;
    private final Qualifier idVersion;

    private Qualifier(int parts) {
        this(parts, null);
    }

    private Qualifier(int parts, Qualifier idVersion) {
        this.parts = parts;
        this.idVersion = idVersion;
    }

    public Optional<Qualifier> getIdVersion() {
        return Optional.ofNullable(this.idVersion);
    }

    public ValidationResult validate(String ... values) {
        if (values == null) {
            return ValidationResult.withError("Input is null");
        }
        if (values.length != this.parts) {
            return ValidationResult.withError(MessageFormat.format("Input has {0} parts instead of {1}", values.length, this.parts));
        }
        if (Arrays.stream(values).anyMatch(val -> val == null || val.isEmpty())) {
            return ValidationResult.withError(MessageFormat.format("Input has null/empty parts.", new Object[0]));
        }
        return ValidationResult.valid();
    }
}

