/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.dependencyanalyzer.dto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jboss.pnc.api.enums.Qualifier;

public class QualifiedVersion {
    private final String version;
    private final Map<Qualifier, Set<String>> qualifiers;

    public QualifiedVersion(String version, Map<Qualifier, Set<String>> qualifiers) {
        this.version = version;
        this.qualifiers = qualifiers;
    }

    public QualifiedVersion(String version) {
        this.version = version;
        this.qualifiers = new HashMap<Qualifier, Set<String>>();
    }

    public static QualifiedVersion of(String version) {
        return new QualifiedVersion(version);
    }

    public boolean has(Qualifier qualifier, String[] values) {
        String joinedValue = Arrays.stream(values).reduce((val1, val2) -> val1 + ' ' + val2).orElse(null);
        return this.qualifiers.containsKey((Object)qualifier) && this.qualifiers.get((Object)qualifier).contains(joinedValue);
    }

    @Generated
    public static QualifiedVersionBuilder builder() {
        return new QualifiedVersionBuilder();
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Map<Qualifier, Set<String>> getQualifiers() {
        return this.qualifiers;
    }

    @Generated
    public String toString() {
        return "QualifiedVersion(version=" + this.getVersion() + ", qualifiers=" + this.getQualifiers() + ")";
    }

    @Generated
    public static class QualifiedVersionBuilder {
        @Generated
        private String version;
        @Generated
        private ArrayList<Qualifier> qualifiers$key;
        @Generated
        private ArrayList<Set<String>> qualifiers$value;

        @Generated
        QualifiedVersionBuilder() {
        }

        @Generated
        public QualifiedVersionBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public QualifiedVersionBuilder qualifier(Qualifier qualifierKey, Set<String> qualifierValue) {
            if (this.qualifiers$key == null) {
                this.qualifiers$key = new ArrayList();
                this.qualifiers$value = new ArrayList();
            }
            this.qualifiers$key.add(qualifierKey);
            this.qualifiers$value.add(qualifierValue);
            return this;
        }

        @Generated
        public QualifiedVersionBuilder qualifiers(Map<? extends Qualifier, ? extends Set<String>> qualifiers) {
            if (qualifiers == null) {
                throw new NullPointerException("qualifiers cannot be null");
            }
            if (this.qualifiers$key == null) {
                this.qualifiers$key = new ArrayList();
                this.qualifiers$value = new ArrayList();
            }
            for (Map.Entry<? extends Qualifier, ? extends Set<String>> $lombokEntry : qualifiers.entrySet()) {
                this.qualifiers$key.add($lombokEntry.getKey());
                this.qualifiers$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public QualifiedVersionBuilder clearQualifiers() {
            if (this.qualifiers$key != null) {
                this.qualifiers$key.clear();
                this.qualifiers$value.clear();
            }
            return this;
        }

        @Generated
        public QualifiedVersion build() {
            Map<Qualifier, Set<String>> qualifiers;
            switch (this.qualifiers$key == null ? 0 : this.qualifiers$key.size()) {
                case 0: {
                    qualifiers = Collections.emptyMap();
                    break;
                }
                case 1: {
                    qualifiers = Collections.singletonMap(this.qualifiers$key.get(0), this.qualifiers$value.get(0));
                    break;
                }
                default: {
                    qualifiers = new LinkedHashMap<Qualifier, Set<String>>(this.qualifiers$key.size() < 0x40000000 ? 1 + this.qualifiers$key.size() + (this.qualifiers$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.qualifiers$key.size(); ++$i) {
                        qualifiers.put(this.qualifiers$key.get($i), this.qualifiers$value.get($i));
                    }
                    qualifiers = Collections.unmodifiableMap(qualifiers);
                }
            }
            return new QualifiedVersion(this.version, qualifiers);
        }

        @Generated
        public String toString() {
            return "QualifiedVersion.QualifiedVersionBuilder(version=" + this.version + ", qualifiers$key=" + this.qualifiers$key + ", qualifiers$value=" + this.qualifiers$value + ")";
        }
    }
}

