/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.reqour.dto.validation;

import java.util.regex.Matcher;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import lombok.Generated;
import org.jboss.pnc.api.dto.validation.DomainNameUtil;
import org.jboss.pnc.api.reqour.dto.validation.GitRepositoryURL;
import org.jboss.pnc.api.reqour.dto.validation.Patterns;

public class GitRepositoryURLValidator
implements ConstraintValidator<GitRepositoryURL, String> {
    private String protocol;
    private String user;
    private String host;
    private int port;
    private String organization;
    private String repository;

    public void initialize(GitRepositoryURL annotation) {
        this.protocol = annotation.protocol();
        this.user = annotation.user();
        this.host = annotation.host();
        this.port = annotation.port();
        this.organization = annotation.organization();
        this.repository = annotation.repository();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        ParsedURL url = GitRepositoryURLValidator.parseURL(value);
        return url != null && !GitRepositoryURLValidator.filledButNotMatchingParsed(this.protocol, url.getProtocol()) && !GitRepositoryURLValidator.filledButNotMatchingParsed(this.user, url.getUser()) && !GitRepositoryURLValidator.filledButNotMatchingParsed(this.host, url.getHost()) && DomainNameUtil.isValidDomainAddress(url.getHost(), url.getProtocol()) && (this.port == -1 || this.port == url.getPort()) && !GitRepositoryURLValidator.filledButNotMatchingParsed(this.organization, url.getOrganization()) && !GitRepositoryURLValidator.filledButNotMatchingParsed(this.repository, url.getRepository());
    }

    public static ParsedURL parseURL(String url) {
        ParsedURL.Builder builder = new ParsedURL.Builder();
        Matcher nonScpLikeMatcher = Patterns.NonScpLike.PATTERN.matcher(url);
        Matcher scpLikeMatcher = Patterns.ScpLike.PATTERN.matcher(url);
        Matcher fileMatcher = Patterns.FileLike.PATTERN.matcher(url);
        if (nonScpLikeMatcher.matches()) {
            return builder.protocol(nonScpLikeMatcher.group("protocol")).user(nonScpLikeMatcher.group("user")).host(nonScpLikeMatcher.group("host")).port(GitRepositoryURLValidator.computePort(nonScpLikeMatcher.group("port"))).organization(nonScpLikeMatcher.group("organization")).repository(nonScpLikeMatcher.group("repository")).build();
        }
        if (scpLikeMatcher.matches()) {
            return builder.protocol(scpLikeMatcher.group("protocol")).user(scpLikeMatcher.group("user")).host(scpLikeMatcher.group("host")).port(GitRepositoryURLValidator.computePort(scpLikeMatcher.group("port"))).organization(scpLikeMatcher.group("organization")).repository(scpLikeMatcher.group("repository")).build();
        }
        if (fileMatcher.matches()) {
            return builder.protocol(fileMatcher.group("protocol")).repository(fileMatcher.group("repository")).build();
        }
        return null;
    }

    static boolean filledButNotMatchingParsed(String valueFromAnnotation, String parsedValue) {
        return valueFromAnnotation != null && !valueFromAnnotation.isEmpty() && !valueFromAnnotation.equals(parsedValue);
    }

    private static int computePort(String portMatch) {
        return portMatch == null ? -1 : Integer.parseInt(portMatch);
    }

    public static final class ParsedURL {
        private final String protocol;
        private final String user;
        private final String host;
        private final int port;
        private final String organization;
        private final String repository;

        @Generated
        ParsedURL(String protocol, String user, String host, int port, String organization, String repository) {
            this.protocol = protocol;
            this.user = user;
            this.host = host;
            this.port = port;
            this.organization = organization;
            this.repository = repository;
        }

        @Generated
        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public String getOrganization() {
            return this.organization;
        }

        @Generated
        public String getRepository() {
            return this.repository;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParsedURL)) {
                return false;
            }
            ParsedURL other = (ParsedURL)o;
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$protocol = this.getProtocol();
            String other$protocol = other.getProtocol();
            if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$organization = this.getOrganization();
            String other$organization = other.getOrganization();
            if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
                return false;
            }
            String this$repository = this.getRepository();
            String other$repository = other.getRepository();
            return !(this$repository == null ? other$repository != null : !this$repository.equals(other$repository));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            String $protocol = this.getProtocol();
            result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $organization = this.getOrganization();
            result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
            String $repository = this.getRepository();
            result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GitRepositoryURLValidator.ParsedURL(protocol=" + this.getProtocol() + ", user=" + this.getUser() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", organization=" + this.getOrganization() + ", repository=" + this.getRepository() + ")";
        }

        @Generated
        public static class Builder {
            @Generated
            private String protocol;
            @Generated
            private String user;
            @Generated
            private String host;
            @Generated
            private int port;
            @Generated
            private String organization;
            @Generated
            private String repository;

            @Generated
            Builder() {
            }

            @Generated
            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            @Generated
            public Builder user(String user) {
                this.user = user;
                return this;
            }

            @Generated
            public Builder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public Builder port(int port) {
                this.port = port;
                return this;
            }

            @Generated
            public Builder organization(String organization) {
                this.organization = organization;
                return this;
            }

            @Generated
            public Builder repository(String repository) {
                this.repository = repository;
                return this;
            }

            @Generated
            public ParsedURL build() {
                return new ParsedURL(this.protocol, this.user, this.host, this.port, this.organization, this.repository);
            }

            @Generated
            public String toString() {
                return "GitRepositoryURLValidator.ParsedURL.Builder(protocol=" + this.protocol + ", user=" + this.user + ", host=" + this.host + ", port=" + this.port + ", organization=" + this.organization + ", repository=" + this.repository + ")";
            }
        }
    }
}

