/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

@JsonDeserialize(builder=Builder.class)
public class ComponentVersion {
    @NonNull
    private String name;
    @NonNull
    private String version;
    private String commit;
    private ZonedDateTime builtOn;
    private List<ComponentVersion> components;

    public void addComponent(ComponentVersion version) {
        if (this.components == null) {
            this.components = new ArrayList<ComponentVersion>();
        }
        this.components.add(version);
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public ComponentVersion(@NonNull String name, @NonNull String version) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.name = name;
        this.version = version;
    }

    @Generated
    private ComponentVersion(@NonNull String name, @NonNull String version, String commit, ZonedDateTime builtOn, List<ComponentVersion> components) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.name = name;
        this.version = version;
        this.commit = commit;
        this.builtOn = builtOn;
        this.components = components;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getCommit() {
        return this.commit;
    }

    @Generated
    public ZonedDateTime getBuiltOn() {
        return this.builtOn;
    }

    @Generated
    public List<ComponentVersion> getComponents() {
        return this.components;
    }

    @Generated
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Generated
    public void setVersion(@NonNull String version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.version = version;
    }

    @Generated
    public void setCommit(String commit) {
        this.commit = commit;
    }

    @Generated
    public void setBuiltOn(ZonedDateTime builtOn) {
        this.builtOn = builtOn;
    }

    @Generated
    public void setComponents(List<ComponentVersion> components) {
        this.components = components;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentVersion)) {
            return false;
        }
        ComponentVersion other = (ComponentVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$commit = this.getCommit();
        String other$commit = other.getCommit();
        if (this$commit == null ? other$commit != null : !this$commit.equals(other$commit)) {
            return false;
        }
        ZonedDateTime this$builtOn = this.getBuiltOn();
        ZonedDateTime other$builtOn = other.getBuiltOn();
        if (this$builtOn == null ? other$builtOn != null : !((Object)this$builtOn).equals(other$builtOn)) {
            return false;
        }
        List<ComponentVersion> this$components = this.getComponents();
        List<ComponentVersion> other$components = other.getComponents();
        return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComponentVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $commit = this.getCommit();
        result = result * 59 + ($commit == null ? 43 : $commit.hashCode());
        ZonedDateTime $builtOn = this.getBuiltOn();
        result = result * 59 + ($builtOn == null ? 43 : ((Object)$builtOn).hashCode());
        List<ComponentVersion> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ComponentVersion(name=" + this.getName() + ", version=" + this.getVersion() + ", commit=" + this.getCommit() + ", builtOn=" + this.getBuiltOn() + ", components=" + this.getComponents() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class Builder {
        @Generated
        private String name;
        @Generated
        private String version;
        @Generated
        private String commit;
        @Generated
        private ZonedDateTime builtOn;
        @Generated
        private ArrayList<ComponentVersion> components;

        @Generated
        Builder() {
        }

        @Generated
        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public Builder version(@NonNull String version) {
            if (version == null) {
                throw new NullPointerException("version is marked non-null but is null");
            }
            this.version = version;
            return this;
        }

        @Generated
        public Builder commit(String commit) {
            this.commit = commit;
            return this;
        }

        @Generated
        public Builder builtOn(ZonedDateTime builtOn) {
            this.builtOn = builtOn;
            return this;
        }

        @Generated
        public Builder component(ComponentVersion component) {
            if (this.components == null) {
                this.components = new ArrayList();
            }
            this.components.add(component);
            return this;
        }

        @Generated
        public Builder components(Collection<? extends ComponentVersion> components) {
            if (components == null) {
                throw new NullPointerException("components cannot be null");
            }
            if (this.components == null) {
                this.components = new ArrayList();
            }
            this.components.addAll(components);
            return this;
        }

        @Generated
        public Builder clearComponents() {
            if (this.components != null) {
                this.components.clear();
            }
            return this;
        }

        @Generated
        public ComponentVersion build() {
            List<Object> components;
            switch (this.components == null ? 0 : this.components.size()) {
                case 0: {
                    components = Collections.emptyList();
                    break;
                }
                case 1: {
                    components = Collections.singletonList(this.components.get(0));
                    break;
                }
                default: {
                    components = Collections.unmodifiableList(new ArrayList<ComponentVersion>(this.components));
                }
            }
            return new ComponentVersion(this.name, this.version, this.commit, this.builtOn, components);
        }

        @Generated
        public String toString() {
            return "ComponentVersion.Builder(name=" + this.name + ", version=" + this.version + ", commit=" + this.commit + ", builtOn=" + this.builtOn + ", components=" + this.components + ")";
        }
    }
}

