/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.enums;

import org.jboss.pnc.api.enums.BuildProgress;

public enum BuildStatus {
    SUCCESS(BuildProgress.FINISHED, true),
    FAILED(BuildProgress.FINISHED, false),
    NO_REBUILD_REQUIRED(BuildProgress.FINISHED, true),
    ENQUEUED(BuildProgress.PENDING),
    WAITING_FOR_DEPENDENCIES(BuildProgress.PENDING),
    BUILDING(BuildProgress.IN_PROGRESS),
    REJECTED(BuildProgress.FINISHED, false),
    REJECTED_FAILED_DEPENDENCIES(BuildProgress.FINISHED, false),
    CANCELLED(BuildProgress.FINISHED, false),
    SYSTEM_ERROR(BuildProgress.FINISHED, false),
    NEW(BuildProgress.PENDING);

    private final boolean completedSuccessfully;
    private final BuildProgress progress;

    private BuildStatus(BuildProgress progress) {
        this(progress, false);
    }

    private BuildStatus(BuildProgress progress, boolean completedSuccessfully) {
        this.completedSuccessfully = completedSuccessfully;
        this.progress = progress;
    }

    public boolean completedSuccessfully() {
        return this.completedSuccessfully;
    }

    public boolean isFinal() {
        return this.progress == BuildProgress.FINISHED;
    }

    public BuildProgress progress() {
        return this.progress;
    }
}

