/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.bifrost.dto;

import java.text.MessageFormat;
import java.util.Map;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import lombok.Generated;
import org.jboss.pnc.api.bifrost.enums.Format;

public class Line {
    private String id;
    private String timestamp;
    private String sequence;
    private String loggerName;
    private String message;
    private String stackTrace;
    private boolean last;
    private Map<String, String> mdc;
    private String subscriptionTopic;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Line fromString(String json) {
        Jsonb jsonb = JsonbBuilder.create();
        return (Line)jsonb.fromJson(json, Line.class);
    }

    public static Builder newBuilder(Line copy) {
        Builder builder = new Builder();
        builder.id = copy.getId();
        builder.timestamp = copy.getTimestamp();
        builder.sequence = copy.getSequence();
        builder.loggerName = copy.getLoggerName();
        builder.message = copy.getMessage();
        builder.stackTrace = copy.getStackTrace();
        builder.last = copy.isLast();
        builder.mdc = copy.getMdc();
        return builder;
    }

    public String asString() {
        return this.asString(Format.DEFAULT);
    }

    public String asString(Format format) {
        switch (format) {
            case TIMESTAMP: {
                return this.getTimestamp() + " " + this.getMessage();
            }
            case PLAIN: {
                return this.getMessage();
            }
            case LEVEL: {
                return this.getLevel() + this.getMessage();
            }
        }
        return this.getTimestamp() + " " + this.getLoggerName() + " " + this.getMessage();
    }

    private String getLevel() {
        if (this.mdc.containsKey("level")) {
            return MessageFormat.format("[{0}] ", this.mdc.get("level"));
        }
        return null;
    }

    public Builder cloneBuilder() {
        return Line.newBuilder(this);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getSequence() {
        return this.sequence;
    }

    @Generated
    public String getLoggerName() {
        return this.loggerName;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getStackTrace() {
        return this.stackTrace;
    }

    @Generated
    public boolean isLast() {
        return this.last;
    }

    @Generated
    public Map<String, String> getMdc() {
        return this.mdc;
    }

    @Generated
    public String getSubscriptionTopic() {
        return this.subscriptionTopic;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    @Generated
    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    @Generated
    public void setLast(boolean last) {
        this.last = last;
    }

    @Generated
    public void setMdc(Map<String, String> mdc) {
        this.mdc = mdc;
    }

    @Generated
    public void setSubscriptionTopic(String subscriptionTopic) {
        this.subscriptionTopic = subscriptionTopic;
    }

    @Generated
    public String toString() {
        return "Line(id=" + this.getId() + ", timestamp=" + this.getTimestamp() + ", sequence=" + this.getSequence() + ", loggerName=" + this.getLoggerName() + ", message=" + this.getMessage() + ", stackTrace=" + this.getStackTrace() + ", last=" + this.isLast() + ", mdc=" + this.getMdc() + ", subscriptionTopic=" + this.getSubscriptionTopic() + ")";
    }

    public static final class Builder {
        private String id;
        private String timestamp;
        private String sequence;
        private String loggerName;
        private String message;
        private String stackTrace;
        private boolean last;
        private Map<String, String> mdc;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder sequence(String sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder logger(String logger) {
            this.loggerName = logger;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder stackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public Builder last(boolean last) {
            this.last = last;
            return this;
        }

        public Builder mdc(Map<String, String> mdc) {
            this.mdc = mdc;
            return this;
        }

        public Line build() {
            Line line = new Line();
            line.id = this.id;
            line.timestamp = this.timestamp;
            line.sequence = this.sequence;
            line.loggerName = this.loggerName;
            line.message = this.message;
            line.stackTrace = this.stackTrace;
            line.last = this.last;
            line.mdc = this.mdc;
            return line;
        }
    }
}

