/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.reqour.dto.validation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.jboss.pnc.api.dto.validation.DomainNameUtil;
import org.jboss.pnc.api.reqour.dto.validation.GitRepositoryURLValidator;
import org.jboss.pnc.api.reqour.dto.validation.NullableGitRepositoryURL;

public class NullableGitRepositoryURLValidator
implements ConstraintValidator<NullableGitRepositoryURL, String> {
    private String protocol;
    private String user;
    private String host;
    private int port;
    private String organization;
    private String repository;

    public void initialize(NullableGitRepositoryURL annotation) {
        this.protocol = annotation.protocol();
        this.user = annotation.user();
        this.host = annotation.host();
        this.port = annotation.port();
        this.organization = annotation.organization();
        this.repository = annotation.repository();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value.isEmpty()) {
            return false;
        }
        GitRepositoryURLValidator.ParsedURL url = GitRepositoryURLValidator.parseURL(value);
        return url != null && !GitRepositoryURLValidator.filledButNotMatchingParsed(this.protocol, url.getProtocol()) && !GitRepositoryURLValidator.filledButNotMatchingParsed(this.user, url.getUser()) && !GitRepositoryURLValidator.filledButNotMatchingParsed(this.host, url.getHost()) && DomainNameUtil.isValidDomainAddress(url.getHost(), url.getProtocol()) && (this.port == -1 || this.port == url.getPort()) && !GitRepositoryURLValidator.filledButNotMatchingParsed(this.organization, url.getOrganization()) && !GitRepositoryURLValidator.filledButNotMatchingParsed(this.repository, url.getRepository());
    }
}

