/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base32;
import org.jboss.pnc.common.Strings;

public class Numbers {
    public static final String BASE32_PATTERN_STRING = "[A-Z2-7]+";
    private static final Pattern BASE32_PATTERN = Pattern.compile("[A-Z2-7]+");
    private static Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
    private static Base64.Decoder decoder = Base64.getUrlDecoder();
    private static Base32 base32 = new Base32();

    public static byte[] longToBytes(long l) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(l);
        return buffer.array();
    }

    public static long bytesToLong(byte[] bytes) {
        if (bytes.length > 8) {
            throw new BufferOverflowException();
        }
        byte[] longBytes = new byte[8];
        System.arraycopy(bytes, 0, longBytes, longBytes.length - bytes.length, bytes.length);
        return ByteBuffer.wrap(longBytes).getLong();
    }

    public static String decimalToBase64(long l) {
        return encoder.encodeToString(Numbers.longToBytes(l));
    }

    public static String decimalToBase32(long l) {
        return base32.encodeToString(Numbers.longToBytes(l)).substring(0, 13);
    }

    public static Long base64ToDecimal(String numeralBase64) {
        if (Strings.isEmpty(numeralBase64)) {
            return null;
        }
        return Numbers.bytesToLong(decoder.decode(numeralBase64));
    }

    public static Long base32ToDecimal(String numeralBase32) {
        if (Strings.isEmpty(numeralBase32)) {
            return null;
        }
        if (numeralBase32.length() != 13) {
            throw new IllegalArgumentException("Long base32 encoding needs exactly 13 digits.");
        }
        if (!BASE32_PATTERN.matcher(numeralBase32).matches()) {
            throw new IllegalArgumentException("Long base32 encoding needs to match '[A-Z2-7]+'.");
        }
        return Numbers.bytesToLong(base32.decode(numeralBase32));
    }
}

