/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.security;

import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CheckSum {
    static String calculateDigest(String message, String algorithm) throws NoSuchAlgorithmException, IOException {
        int read;
        MessageDigest md = MessageDigest.getInstance(algorithm);
        StringReader reader = new StringReader(message);
        char[] buffer = new char[1024];
        while ((read = reader.read(buffer)) != -1) {
            md.update(String.valueOf(buffer, 0, read).getBytes(StandardCharsets.UTF_8));
        }
        byte[] digest = md.digest();
        return CheckSum.format(digest);
    }

    static String format(byte[] digest) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : digest) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

