/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.alignment.ranking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import org.jboss.pnc.api.dependencyanalyzer.dto.QualifiedVersion;
import org.jboss.pnc.common.alignment.ranking.compiler.Compiler;
import org.jboss.pnc.common.alignment.ranking.compiler.PredicateCompiler;
import org.jboss.pnc.common.alignment.ranking.exception.ValidationException;
import org.jboss.pnc.common.alignment.ranking.parser.DefaultParser;
import org.jboss.pnc.common.alignment.ranking.parser.InternalNode;
import org.jboss.pnc.common.alignment.ranking.parser.Parser;
import org.jboss.pnc.common.alignment.ranking.tokenizer.GenericTokenizer;
import org.jboss.pnc.common.alignment.ranking.tokenizer.Token;
import org.jboss.pnc.common.alignment.ranking.tokenizer.TokenType;

public class AlignmentPredicate
implements Predicate<QualifiedVersion> {
    private static final EnumSet<TokenType> ALLOWED_TOKENS = EnumSet.of(TokenType.QVALUE, TokenType.COMMA);
    private final Parser parser = new DefaultParser();
    private final Compiler<Predicate<QualifiedVersion>> compiler = new PredicateCompiler();
    private List<Token> tokens;
    private InternalNode root;
    private Predicate<QualifiedVersion> predicate;

    public AlignmentPredicate(String query) throws ValidationException {
        this(query, ver -> true);
    }

    public AlignmentPredicate(String query, Predicate<QualifiedVersion> defaultBehaviour) throws ValidationException {
        this.compile(query, defaultBehaviour);
    }

    private void compile(String query, Predicate<QualifiedVersion> defaultBehaviour) throws ValidationException {
        if (query == null) {
            this.tokens = Collections.emptyList();
            this.predicate = defaultBehaviour;
            return;
        }
        GenericTokenizer tokenizer = new GenericTokenizer(query, ALLOWED_TOKENS);
        this.tokens = new ArrayList<Token>();
        while (tokenizer.hasNext()) {
            this.tokens.add(tokenizer.next());
        }
        this.root = this.parser.generateParseTree(this.tokens);
        this.predicate = this.compiler.compile(this.root);
    }

    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    @Override
    public boolean test(QualifiedVersion version) {
        return this.predicate.test(version);
    }
}

