/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.alignment.ranking;

import java.util.List;
import org.jboss.pnc.common.alignment.ranking.AlignmentPredicate;
import org.jboss.pnc.common.alignment.ranking.AlignmentRanking;

public class VersionStrategy {
    private final AlignmentRanking ranks;
    private final AlignmentPredicate denyList;
    private final AlignmentPredicate allowList;

    public static VersionStrategy none() {
        return ((VersionStrategyBuilder)((VersionStrategyBuilder)((VersionStrategyBuilder)VersionStrategy.builder().ranks(new AlignmentRanking(null, null))).allowList(new AlignmentPredicate(null, ver -> true))).denyList(new AlignmentPredicate(null, ver -> false))).build();
    }

    public static VersionStrategy from(List<String> ranks, String allowList, String denyList) {
        return ((VersionStrategyBuilder)((VersionStrategyBuilder)((VersionStrategyBuilder)VersionStrategy.builder().ranks(new AlignmentRanking(ranks, null))).allowList(new AlignmentPredicate(allowList, ver -> true))).denyList(new AlignmentPredicate(denyList, ver -> false))).build();
    }

    protected VersionStrategy(VersionStrategyBuilder<?, ?> b) {
        this.ranks = b.ranks;
        this.denyList = b.denyList;
        this.allowList = b.allowList;
    }

    public static VersionStrategyBuilder<?, ?> builder() {
        return new VersionStrategyBuilderImpl();
    }

    public VersionStrategy(AlignmentRanking ranks, AlignmentPredicate denyList, AlignmentPredicate allowList) {
        this.ranks = ranks;
        this.denyList = denyList;
        this.allowList = allowList;
    }

    public AlignmentRanking getRanks() {
        return this.ranks;
    }

    public AlignmentPredicate getDenyList() {
        return this.denyList;
    }

    public AlignmentPredicate getAllowList() {
        return this.allowList;
    }

    public static abstract class VersionStrategyBuilder<C extends VersionStrategy, B extends VersionStrategyBuilder<C, B>> {
        private AlignmentRanking ranks;
        private AlignmentPredicate denyList;
        private AlignmentPredicate allowList;

        public B ranks(AlignmentRanking ranks) {
            this.ranks = ranks;
            return this.self();
        }

        public B denyList(AlignmentPredicate denyList) {
            this.denyList = denyList;
            return this.self();
        }

        public B allowList(AlignmentPredicate allowList) {
            this.allowList = allowList;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "VersionStrategy.VersionStrategyBuilder(ranks=" + this.ranks + ", denyList=" + this.denyList + ", allowList=" + this.allowList + ")";
        }
    }

    private static final class VersionStrategyBuilderImpl
    extends VersionStrategyBuilder<VersionStrategy, VersionStrategyBuilderImpl> {
        private VersionStrategyBuilderImpl() {
        }

        @Override
        protected VersionStrategyBuilderImpl self() {
            return this;
        }

        @Override
        public VersionStrategy build() {
            return new VersionStrategy(this);
        }
    }
}

