/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.alignment.ranking.compiler;

import java.util.Comparator;
import org.jboss.pnc.api.dependencyanalyzer.dto.QualifiedVersion;
import org.jboss.pnc.common.alignment.ranking.compiler.AbstractCompiler;
import org.jboss.pnc.common.alignment.ranking.compiler.Compiler;
import org.jboss.pnc.common.alignment.ranking.parser.BinaryNode;
import org.jboss.pnc.common.alignment.ranking.parser.LeafNode;
import org.jboss.pnc.common.alignment.ranking.parser.Node;
import org.jboss.pnc.common.alignment.ranking.tokenizer.OrderToken;

public class RankCompiler
extends AbstractCompiler<Comparator<QualifiedVersion>>
implements Compiler<Comparator<QualifiedVersion>> {
    private Comparator<String> suffixVersionComparator = Comparator.naturalOrder();

    @Override
    protected Comparator<QualifiedVersion> handleBinaryNode(BinaryNode bNode) {
        switch (bNode.getToken().tokenType) {
            case LOGIC: {
                return (ver1, ver2) -> this.evaluateTree(bNode, (QualifiedVersion)ver1, (QualifiedVersion)ver2);
            }
            case SORT_BY: {
                Node rightChild = bNode.getRightChild();
                if (!(rightChild instanceof LeafNode)) {
                    throw new IllegalArgumentException("Order Token leaf node required");
                }
                Node left = bNode.getLeftChild();
                LeafNode right = (LeafNode)rightChild;
                return (ver1, ver2) -> this.evaluateWithSort(left, right, (QualifiedVersion)ver1, (QualifiedVersion)ver2);
            }
        }
        throw new IllegalArgumentException("Binary Node with unusual Token Type: " + bNode.getToken());
    }

    @Override
    protected Comparator<QualifiedVersion> handleLeafNode(LeafNode lNode) {
        switch (lNode.getToken().tokenType) {
            case QVALUE: {
                return (ver1, ver2) -> this.evaluateTree(lNode, (QualifiedVersion)ver1, (QualifiedVersion)ver2);
            }
            case ORDER: {
                return (ver1, ver2) -> this.compareByOrder(lNode, (QualifiedVersion)ver1, (QualifiedVersion)ver2);
            }
        }
        throw new IllegalArgumentException("LeafNode of impossible tokenType: " + lNode.getToken());
    }

    private int evaluateWithSort(Node left, LeafNode right, QualifiedVersion ver1, QualifiedVersion ver2) {
        boolean first = this.match(left, ver1);
        boolean second = this.match(left, ver2);
        if (first && second) {
            return this.compareByOrder(right, ver1, ver2);
        }
        if (!first && !second) {
            return 0;
        }
        if (first && !second) {
            return 1;
        }
        return -1;
    }

    private int compareByOrder(LeafNode right, QualifiedVersion ver1, QualifiedVersion ver2) {
        OrderToken token = (OrderToken)right.getToken();
        switch (token.order) {
            case SUFFIX_VERSION: {
                return Comparator.comparing(QualifiedVersion::getVersion, this.suffixVersionComparator).compare(ver1, ver2);
            }
        }
        throw new IllegalArgumentException("Unknown Order Type");
    }

    private int evaluateTree(Node child, QualifiedVersion ver1, QualifiedVersion ver2) {
        boolean second;
        boolean first = this.match(child, ver1);
        if (first == (second = this.match(child, ver2))) {
            return 0;
        }
        if (first && !second) {
            return 1;
        }
        return -1;
    }

    public RankCompiler() {
    }

    public RankCompiler(Comparator<String> suffixVersionComparator) {
        this.suffixVersionComparator = suffixVersionComparator;
    }

    public void setSuffixVersionComparator(Comparator<String> suffixVersionComparator) {
        this.suffixVersionComparator = suffixVersionComparator;
    }
}

