/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.alignment.ranking.parser;

import java.util.List;
import org.jboss.pnc.common.alignment.ranking.parser.AbstractNode;
import org.jboss.pnc.common.alignment.ranking.parser.InternalNode;
import org.jboss.pnc.common.alignment.ranking.parser.Node;
import org.jboss.pnc.common.alignment.ranking.parser.Priority;
import org.jboss.pnc.common.alignment.ranking.tokenizer.Token;

public class BinaryNode
extends AbstractNode
implements InternalNode,
Priority {
    private Node leftChild;
    private Node rightChild;
    private final int priority;

    public BinaryNode(Token token) {
        this(null, token);
    }

    public BinaryNode(InternalNode parent, Token token) {
        super(parent, token);
        this.priority = this.getPriority(token);
    }

    @Override
    public int childrenCount() {
        int count = 0;
        if (this.leftChild != null) {
            ++count;
        }
        if (this.rightChild != null) {
            ++count;
        }
        return count;
    }

    @Override
    public List<Node> getChildren() {
        return List.of(this.leftChild, this.rightChild);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public Node getLeftChild() {
        return this.leftChild;
    }

    public Node getRightChild() {
        return this.rightChild;
    }

    public void setRightChild(Node node) {
        node.setParent(this);
        this.rightChild = node;
    }

    public void setLeftChild(Node node) {
        node.setParent(this);
        this.leftChild = node;
    }

    @Override
    public void removeChild(Node child) {
        if (this.leftChild == child) {
            this.leftChild = null;
            if (child.getParent() == this) {
                child.setParent(null);
            }
        } else if (this.rightChild == child) {
            this.rightChild = null;
            if (child.getParent() == this) {
                child.setParent(null);
            }
        }
    }

    @Override
    public void switchChild(Node badChild, Node goodChild) {
        if (this.leftChild == badChild) {
            this.removeChild(badChild);
            this.setLeftChild(goodChild);
        } else if (this.rightChild == badChild) {
            this.removeChild(badChild);
            this.setRightChild(goodChild);
        }
    }
}

