/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.alignment.ranking.parser;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.pnc.common.alignment.ranking.exception.ValidationException;
import org.jboss.pnc.common.alignment.ranking.parser.BinaryNode;
import org.jboss.pnc.common.alignment.ranking.parser.InternalNode;
import org.jboss.pnc.common.alignment.ranking.parser.LeafNode;
import org.jboss.pnc.common.alignment.ranking.parser.Node;
import org.jboss.pnc.common.alignment.ranking.parser.Parser;
import org.jboss.pnc.common.alignment.ranking.parser.UnaryNode;
import org.jboss.pnc.common.alignment.ranking.tokenizer.Token;
import org.jboss.pnc.common.alignment.ranking.tokenizer.TokenType;

public class DefaultParser
implements Parser {
    private static final Set<TokenType> START = new HashSet<TokenType>(EnumSet.of(TokenType.QVALUE, TokenType.ORDER, TokenType.LPAREN));
    private static final Map<TokenType, Set<TokenType>> ALLOWED_NEXT_TOKENS = new HashMap<TokenType, Set<TokenType>>();

    @Override
    public InternalNode generateParseTree(List<Token> tokens) throws ValidationException {
        UnaryNode rootNode = new UnaryNode();
        this.validateInput(tokens);
        this.createParseTree(rootNode, 0, tokens, 0);
        return rootNode;
    }

    private void validateInput(List<Token> tokens) throws ValidationException {
        if (tokens.isEmpty()) {
            if (!START.contains(null)) {
                throw new ValidationException("Empty list of tokens is not allowed.");
            }
            return;
        }
        for (int i = 0; i < tokens.size(); ++i) {
            Token currentToken = tokens.get(i);
            TokenType nextType = this.peekType(i + 1, tokens);
            if (ALLOWED_NEXT_TOKENS.get((Object)currentToken.tokenType).contains((Object)nextType)) continue;
            throw new ValidationException(nextType + "is not allowed after " + tokens.get(i), tokens.get(i));
        }
    }

    private TokenType peekType(int toPeek, List<Token> tokens) {
        if (toPeek >= tokens.size()) {
            return null;
        }
        return tokens.get((int)toPeek).tokenType;
    }

    private void createParseTree(InternalNode currentNode, int tokenIdx, List<Token> tokens, int parenChecker) throws ValidationException {
        InternalNode next;
        if (tokenIdx >= tokens.size()) {
            if (parenChecker != 0) {
                throw new ValidationException("Amount of parentheses do not match. Expecting another " + parenChecker + ".", tokens.get((int)(tokens.size() - 1)).endPos);
            }
            return;
        }
        Token token = tokens.get(tokenIdx);
        switch (token.tokenType) {
            case QVALUE: 
            case ORDER: {
                DefaultParser.addLeaf(currentNode, token);
                next = currentNode;
                break;
            }
            case LOGIC: 
            case COMMA: {
                BinaryNode newNode = this.addBinaryNode(currentNode, token);
                next = newNode;
                break;
            }
            case LPAREN: {
                UnaryNode parenthesesWrapper = new UnaryNode(token);
                ++parenChecker;
                if (currentNode instanceof UnaryNode) {
                    ((UnaryNode)currentNode).setChild(parenthesesWrapper);
                } else if (currentNode instanceof BinaryNode) {
                    ((BinaryNode)currentNode).setRightChild(parenthesesWrapper);
                }
                next = parenthesesWrapper;
                break;
            }
            case RPAREN: {
                if (parenChecker <= 0) {
                    throw new ValidationException("Illegal ')' placement.", token);
                }
                --parenChecker;
                InternalNode node = currentNode.getParent();
                while (!(node instanceof UnaryNode)) {
                    node = node.getParent();
                }
                UnaryNode leftParenNode = (UnaryNode)node;
                InternalNode parenParent = leftParenNode.getParent();
                Node parenChild = leftParenNode.getChild();
                leftParenNode.removeChild(parenChild);
                parenParent.switchChild(leftParenNode, parenChild);
                next = parenParent;
                break;
            }
            case SORT_BY: {
                BinaryNode sortNode = new BinaryNode(token);
                InternalNode rootNode = DefaultParser.findRoot(currentNode);
                this.pushDown((UnaryNode)rootNode, sortNode);
                next = sortNode;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported token in token list");
            }
        }
        this.createParseTree(next, ++tokenIdx, tokens, parenChecker);
    }

    private static void addLeaf(InternalNode currentNode, Token token) {
        LeafNode leaf = new LeafNode(token);
        if (currentNode instanceof UnaryNode) {
            ((UnaryNode)currentNode).setChild(leaf);
        } else if (currentNode instanceof BinaryNode) {
            BinaryNode binary = (BinaryNode)currentNode;
            if (binary.getLeftChild() == null) {
                binary.setLeftChild(leaf);
            }
            if (binary.getRightChild() == null) {
                binary.setRightChild(leaf);
            }
        }
    }

    private BinaryNode addBinaryNode(InternalNode currentNode, Token token) {
        BinaryNode newNode = new BinaryNode(token);
        if (currentNode instanceof UnaryNode) {
            UnaryNode unary = (UnaryNode)currentNode;
            this.pushDown(unary, newNode);
        } else if (currentNode instanceof BinaryNode) {
            BinaryNode currentBinary = (BinaryNode)currentNode;
            if (currentBinary.getPriority() <= newNode.getPriority()) {
                Node rightChild = currentBinary.getRightChild();
                currentBinary.switchChild(rightChild, newNode);
                newNode.setLeftChild(rightChild);
            } else {
                InternalNode currentParent = currentBinary.getParent();
                currentParent.switchChild(currentBinary, newNode);
                newNode.setLeftChild(currentBinary);
            }
        }
        return newNode;
    }

    private static InternalNode findRoot(InternalNode currentNode) {
        InternalNode node = currentNode;
        while (node.getParent() != null) {
            node = node.getParent();
        }
        return node;
    }

    private void pushDown(UnaryNode parent, BinaryNode node) {
        Node parentChild = parent.getChild();
        parent.switchChild(parentChild, node);
        node.setLeftChild(parentChild);
    }

    static {
        block9: for (TokenType value : TokenType.values()) {
            ALLOWED_NEXT_TOKENS.put(value, new HashSet());
            switch (value) {
                case QVALUE: {
                    ALLOWED_NEXT_TOKENS.get((Object)TokenType.QVALUE).addAll(Set.of(TokenType.LOGIC, TokenType.COMMA, TokenType.SORT_BY, TokenType.RPAREN));
                    ALLOWED_NEXT_TOKENS.get((Object)TokenType.QVALUE).add(null);
                    continue block9;
                }
                case ORDER: {
                    ALLOWED_NEXT_TOKENS.get((Object)TokenType.ORDER).add(null);
                    continue block9;
                }
                case LOGIC: {
                    ALLOWED_NEXT_TOKENS.get((Object)TokenType.LOGIC).addAll(Set.of(TokenType.QVALUE, TokenType.LPAREN));
                    continue block9;
                }
                case LPAREN: {
                    ALLOWED_NEXT_TOKENS.get((Object)TokenType.LPAREN).addAll(Set.of(TokenType.QVALUE, TokenType.LPAREN));
                    continue block9;
                }
                case RPAREN: {
                    ALLOWED_NEXT_TOKENS.get((Object)TokenType.RPAREN).addAll(Set.of(TokenType.LOGIC, TokenType.COMMA, TokenType.SORT_BY, TokenType.RPAREN));
                    ALLOWED_NEXT_TOKENS.get((Object)TokenType.RPAREN).add(null);
                    continue block9;
                }
                case COMMA: {
                    ALLOWED_NEXT_TOKENS.get((Object)TokenType.COMMA).addAll(Set.of(TokenType.QVALUE, TokenType.LPAREN));
                    continue block9;
                }
                case SORT_BY: {
                    ALLOWED_NEXT_TOKENS.get((Object)TokenType.SORT_BY).add(TokenType.ORDER);
                }
            }
        }
    }
}

