/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.alignment.ranking.tokenizer;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.pnc.api.enums.Qualifier;
import org.jboss.pnc.common.alignment.ranking.Logic;
import org.jboss.pnc.common.alignment.ranking.Order;
import org.jboss.pnc.common.alignment.ranking.exception.ValidationException;
import org.jboss.pnc.common.alignment.ranking.tokenizer.LogicToken;
import org.jboss.pnc.common.alignment.ranking.tokenizer.OrderToken;
import org.jboss.pnc.common.alignment.ranking.tokenizer.QualifierToken;
import org.jboss.pnc.common.alignment.ranking.tokenizer.Token;
import org.jboss.pnc.common.alignment.ranking.tokenizer.TokenKind;
import org.jboss.pnc.common.alignment.ranking.tokenizer.TokenType;
import org.jboss.pnc.common.alignment.ranking.tokenizer.Tokenizer;

public class GenericTokenizer
implements Tokenizer {
    static final byte EOL = 25;
    private final Set<TokenType> allowedTokens;
    private final Set<TokenType> charKindTokens;
    private final Set<Character> charKindChars;
    private final Set<TokenType> literalKindTokens;
    private final Set<TokenType> enumTokens;
    private final Set<TokenType> stringKindTypes;
    private final Set<Character> blacklistedChars;
    private final StringBuilder buffer;
    private TokenType tokenType;
    private char character;
    private int position;
    private boolean incPosition;
    private final String input;
    private int savePos;

    public GenericTokenizer(String input) {
        this(input, EnumSet.allOf(TokenType.class), Collections.emptySet());
    }

    public GenericTokenizer(String input, Set<TokenType> allowedTokens) {
        this(input, allowedTokens, Collections.emptySet());
    }

    public GenericTokenizer(String input, Set<TokenType> allowedTokens, Set<Character> blacklistedChars) {
        this.input = input;
        this.buffer = new StringBuilder(255);
        this.character = '\u0000';
        this.position = 0;
        this.allowedTokens = allowedTokens;
        this.charKindTokens = allowedTokens.stream().filter(tt -> tt.kind == TokenKind.CHAR).collect(Collectors.toSet());
        this.charKindChars = this.charKindTokens.stream().map(t -> Character.valueOf(t.charLiteral)).collect(Collectors.toSet());
        this.literalKindTokens = allowedTokens.stream().filter(tt -> tt.kind == TokenKind.LITERAL).collect(Collectors.toSet());
        this.enumTokens = allowedTokens.stream().filter(tt -> tt.kind == TokenKind.ENUM).collect(Collectors.toSet());
        this.stringKindTypes = Stream.concat(this.literalKindTokens.stream(), this.enumTokens.stream()).collect(Collectors.toSet());
        this.blacklistedChars = blacklistedChars;
        this.incPosition = false;
        this.nextChar();
    }

    private char get() {
        return this.character;
    }

    private char nextChar() {
        if (this.incPosition) {
            ++this.position;
        }
        this.changeChar();
        return this.character;
    }

    private boolean hasChar() {
        return this.position < this.input.length();
    }

    private void changeChar() {
        if (this.blacklistedChars.contains(Character.valueOf(this.character))) {
            throw new ValidationException("Character '" + this.character + "' is not allowed.", this.position);
        }
        if (this.hasChar()) {
            this.character = this.input.charAt(this.position);
            this.incPosition = true;
        } else {
            this.character = (char)25;
            this.incPosition = false;
        }
    }

    private boolean accept(char character) {
        if (this.character == character) {
            this.nextChar();
            return true;
        }
        return false;
    }

    private boolean acceptEither(char ... chars) {
        if (this.isCurChar(chars)) {
            this.nextChar();
            return true;
        }
        return false;
    }

    private boolean acceptIf(Predicate<Character> condition) {
        if (condition.test(Character.valueOf(this.get()))) {
            this.nextChar();
            return true;
        }
        return false;
    }

    private void rollback(int pos) {
        this.position = pos;
        this.incPosition = false;
        this.nextChar();
    }

    private boolean acceptString(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int savePosition = this.position;
        for (char c : string.toCharArray()) {
            if (!this.isCurChar(c)) {
                this.rollback(savePosition);
                return false;
            }
            this.nextChar();
        }
        return true;
    }

    private boolean isCurChar(char ... chars) {
        for (char c : chars) {
            if (this.character != c) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.hasChar() && !this.justWhitespace();
    }

    private boolean justWhitespace() {
        int pos = this.position;
        this.skipWhitespaces();
        if (!this.hasChar()) {
            this.rollback(pos);
            return true;
        }
        return false;
    }

    @Override
    public Token next() {
        this.buffer.setLength(0);
        this.savePos = this.position;
        this.skipWhitespaces();
        if (!this.hasChar()) {
            throw new ValidationException("Just whitespace remaining. No next Token available.", this.savePos, this.position);
        }
        this.savePos = this.position;
        this.bufferWord();
        if (this.buffer.length() > 0) {
            if (!this.tryParseStringToken()) {
                throw new ValidationException("Unrecognized word '" + this.buffer.toString() + "'.", this.savePos, this.position);
            }
        } else if (!this.tryParseCharToken()) {
            throw new ValidationException("Unrecognized character '" + this.get() + "'.", this.savePos, this.position);
        }
        switch (this.tokenType) {
            case QVALUE: {
                String[] qValue = this.buffer.toString().split(":", 2);
                Qualifier qualifier = Qualifier.valueOf((String)this.sanitize(qValue[0]));
                String[] values = qValue[1].trim().split("\\s+");
                return new QualifierToken(this.savePos, this.position, qualifier, values);
            }
            case LOGIC: {
                Logic logic = Logic.valueOf(this.sanitize(this.buffer.toString()));
                return new LogicToken(this.savePos, this.position, logic);
            }
            case ORDER: {
                Order order = Order.valueOf(this.sanitize(this.buffer.toString()));
                return new OrderToken(this.savePos, this.position, order);
            }
            case LPAREN: {
                return new Token(this.savePos, this.position, TokenType.LPAREN);
            }
            case RPAREN: {
                return new Token(this.savePos, this.position, TokenType.RPAREN);
            }
            case SORT_BY: {
                return new Token(this.savePos, this.position, TokenType.SORT_BY);
            }
            case COMMA: {
                return new Token(this.savePos, this.position, TokenType.COMMA);
            }
        }
        throw new IllegalArgumentException("No parsing defined for token type " + this.tokenType.name());
    }

    private String sanitize(String input) {
        return input.toUpperCase().replace('-', '_');
    }

    private boolean tryParseCharToken() {
        block4: for (TokenType type : TokenType.values()) {
            switch (type) {
                case QVALUE: 
                case LOGIC: 
                case ORDER: 
                case SORT_BY: {
                    continue block4;
                }
                case LPAREN: 
                case RPAREN: 
                case COMMA: {
                    if (!this.isCurChar(type.charLiteral)) continue block4;
                    this.accept(type.charLiteral);
                    this.tokenType = type;
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean tryParseStringToken() {
        block5: for (TokenType type : this.stringKindTypes) {
            switch (type) {
                case LOGIC: 
                case ORDER: 
                case SORT_BY: {
                    if (!this.bufferHas(type)) continue block5;
                    this.tokenType = type;
                    return true;
                }
                case QVALUE: {
                    if (this.bufferHas(TokenType.QVALUE)) {
                        this.tokenType = TokenType.QVALUE;
                        Qualifier qualifier = this.bufferGet(Qualifier.class);
                        this.skipWhitespaces();
                        if (!this.isCurChar(':')) {
                            throw new ValidationException("Could not find ':' after parsing Qualifier.", this.savePos, this.position);
                        }
                        this.put();
                        this.nextChar();
                        this.skipWhitespaces();
                        if (this.isCurChar('\'', '\"')) {
                            this.bufferQuotedString(qualifier.parts);
                        } else {
                            for (int part = 0; part < qualifier.parts; ++part) {
                                this.skipWhitespaces();
                                if (!this.bufferWord()) {
                                    throw new ValidationException("Qualifier " + qualifier.name() + " requires " + qualifier.parts + " word/s.", this.savePos, this.position);
                                }
                                if (part == qualifier.parts - 1) continue;
                                this.buffer.append(' ');
                            }
                        }
                        return true;
                    }
                }
                case LPAREN: 
                case RPAREN: 
                case COMMA: {
                    continue block5;
                }
            }
            return false;
        }
        return false;
    }

    private void bufferQuotedString(int parts) {
        String quotedString;
        String[] split;
        if (!this.isCurChar('\'', '\"')) {
            return;
        }
        char quote = this.get();
        this.nextChar();
        int save = this.buffer.length();
        while (this.acceptAndPutIf(ch -> ch.charValue() != quote && this.hasChar())) {
        }
        if (!this.hasChar()) {
            throw new ValidationException("Reached the end of buffer without ending quote " + quote, this.savePos, this.position);
        }
        if (parts > 1 && (split = (quotedString = this.buffer.substring(save).trim()).split("\\s+")).length != parts) {
            throw new ValidationException("Quoted string should have exactly " + parts + " amount of words.", this.savePos, this.position);
        }
        this.nextChar();
    }

    private boolean acceptAndPutIf(Predicate<Character> condition) {
        if (condition.test(Character.valueOf(this.get()))) {
            this.put();
            this.nextChar();
            return true;
        }
        return false;
    }

    private void skipWhitespaces() {
        while (this.acceptIf(Character::isWhitespace)) {
        }
    }

    private <T extends Enum<T>> T bufferGet(Class<T> enumClass) {
        return Enum.valueOf(enumClass, this.sanitize(this.buffer.toString()));
    }

    private <T extends Enum<T>> boolean bufferHas(Class<T> enumClass) {
        try {
            Enum.valueOf(enumClass, this.sanitize(this.buffer.toString()));
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
        return true;
    }

    private boolean bufferHas(TokenType tokenType) {
        switch (tokenType.kind) {
            case LITERAL: {
                return tokenType.literal.equals(this.sanitize(this.buffer.toString()));
            }
            case ENUM: {
                return tokenType.getEnumValues().contains(this.sanitize(this.buffer.toString()));
            }
            case CHAR: {
                throw new IllegalArgumentException("Don't use buffer for character-tokens.");
            }
        }
        throw new IllegalArgumentException("Unknown TokenKind.");
    }

    private boolean bufferWord() {
        boolean filledBuffer = false;
        this.skipWhitespaces();
        while (this.acceptAndPutIf(ch -> !Character.isWhitespace(ch.charValue()) && !this.isSpecial())) {
            filledBuffer = true;
        }
        return filledBuffer;
    }

    private boolean isSpecial() {
        switch (this.get()) {
            case '\u0019': 
            case '\"': 
            case '\'': {
                return true;
            }
        }
        return this.charKindChars.contains(Character.valueOf(this.get())) || this.enumTokens.contains((Object)TokenType.QVALUE) && this.get() == ':';
    }

    private void put() {
        this.buffer.append(this.get());
    }
}

