/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.alignment.ranking.tokenizer;

import java.util.Arrays;
import org.jboss.pnc.api.dto.validation.ValidationResult;
import org.jboss.pnc.api.enums.Qualifier;
import org.jboss.pnc.common.alignment.ranking.exception.ValidationException;
import org.jboss.pnc.common.alignment.ranking.tokenizer.Token;
import org.jboss.pnc.common.alignment.ranking.tokenizer.TokenType;

public class QualifierToken
extends Token {
    public final Qualifier qualifier;
    public final String[] parts;

    public QualifierToken(int pos, int endPos, Qualifier qualifier, String[] parts) {
        super(pos, endPos, TokenType.QVALUE);
        this.qualifier = qualifier;
        this.parts = parts;
        this.assertParts();
    }

    private void assertParts() {
        ValidationResult validation = this.qualifier.validate(this.parts);
        if (!validation.isValid()) {
            throw new ValidationException(validation.getValidationError(), this);
        }
    }

    @Override
    public String toString() {
        return this.qualifier.name() + ":" + String.join((CharSequence)" ", this.parts);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QualifierToken)) {
            return false;
        }
        QualifierToken other = (QualifierToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Qualifier this$qualifier = this.qualifier;
        Qualifier other$qualifier = other.qualifier;
        if (this$qualifier == null ? other$qualifier != null : !this$qualifier.equals(other$qualifier)) {
            return false;
        }
        return Arrays.deepEquals(this.parts, other.parts);
    }

    protected boolean canEqual(Object other) {
        return other instanceof QualifierToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Qualifier $qualifier = this.qualifier;
        result = result * 59 + ($qualifier == null ? 43 : $qualifier.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.parts);
        return result;
    }
}

