/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.pnc;

import org.jboss.pnc.common.Numbers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongBase32IdConverter {
    private static final Logger logger = LoggerFactory.getLogger(LongBase32IdConverter.class);
    public static final long OLD_ID_BOUNDARY = 2222222222222L;
    public static final long HIGHEST_BASE32_NUMBER_LIKE = 9999999999999L;

    public static Long toLong(String id) {
        if (id == null) {
            return null;
        }
        if (id.matches("[0-9]+")) {
            try {
                Long possibleId = Long.parseLong(id);
                if (possibleId < 2222222222222L) {
                    return possibleId;
                }
                if (possibleId > 9999999999999L) {
                    return possibleId;
                }
            }
            catch (NumberFormatException e) {
                logger.warn("Id is not a long.", (Throwable)e);
            }
        }
        return Numbers.base32ToDecimal(id);
    }

    public static String toString(Long id) {
        if (id == null) {
            return null;
        }
        if (id < 2222222222222L) {
            return id.toString();
        }
        return Numbers.decimalToBase32(id);
    }
}

